package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
/**
 * Malware detection entity.
 */
@jakarta.annotation.Generated("com.microsoft.kiota")
public class WindowsDeviceMalwareState extends Entity implements Parsable {
    /**
     * Instantiates a new WindowsDeviceMalwareState and sets the default values.
     */
    public WindowsDeviceMalwareState() {
        super();
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a WindowsDeviceMalwareState
     */
    @jakarta.annotation.Nonnull
    public static WindowsDeviceMalwareState createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WindowsDeviceMalwareState();
    }
    /**
     * Gets the additionalInformationUrl property value. Information URL to learn more about the malware
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getAdditionalInformationUrl() {
        return this.backingStore.get("additionalInformationUrl");
    }
    /**
     * Gets the category property value. Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
     * @return a WindowsMalwareCategory
     */
    @jakarta.annotation.Nullable
    public WindowsMalwareCategory getCategory() {
        return this.backingStore.get("category");
    }
    /**
     * Gets the detectionCount property value. Number of times the malware is detected
     * @return a Integer
     */
    @jakarta.annotation.Nullable
    public Integer getDetectionCount() {
        return this.backingStore.get("detectionCount");
    }
    /**
     * Gets the displayName property value. Malware name
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getDisplayName() {
        return this.backingStore.get("displayName");
    }
    /**
     * Gets the executionState property value. Execution status of the malware like blocked/executing etc. Possible values are: unknown, blocked, allowed, running, notRunning.
     * @return a WindowsMalwareExecutionState
     */
    @jakarta.annotation.Nullable
    public WindowsMalwareExecutionState getExecutionState() {
        return this.backingStore.get("executionState");
    }
    /**
     * The deserialization information for the current model
     * @return a Map<String, java.util.function.Consumer<ParseNode>>
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("additionalInformationUrl", (n) -> { this.setAdditionalInformationUrl(n.getStringValue()); });
        deserializerMap.put("category", (n) -> { this.setCategory(n.getEnumValue(WindowsMalwareCategory::forValue)); });
        deserializerMap.put("detectionCount", (n) -> { this.setDetectionCount(n.getIntegerValue()); });
        deserializerMap.put("displayName", (n) -> { this.setDisplayName(n.getStringValue()); });
        deserializerMap.put("executionState", (n) -> { this.setExecutionState(n.getEnumValue(WindowsMalwareExecutionState::forValue)); });
        deserializerMap.put("initialDetectionDateTime", (n) -> { this.setInitialDetectionDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("lastStateChangeDateTime", (n) -> { this.setLastStateChangeDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("severity", (n) -> { this.setSeverity(n.getEnumValue(WindowsMalwareSeverity::forValue)); });
        deserializerMap.put("state", (n) -> { this.setState(n.getEnumValue(WindowsMalwareState::forValue)); });
        deserializerMap.put("threatState", (n) -> { this.setThreatState(n.getEnumValue(WindowsMalwareThreatState::forValue)); });
        return deserializerMap;
    }
    /**
     * Gets the initialDetectionDateTime property value. Initial detection datetime of the malware
     * @return a OffsetDateTime
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getInitialDetectionDateTime() {
        return this.backingStore.get("initialDetectionDateTime");
    }
    /**
     * Gets the lastStateChangeDateTime property value. The last time this particular threat was changed
     * @return a OffsetDateTime
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getLastStateChangeDateTime() {
        return this.backingStore.get("lastStateChangeDateTime");
    }
    /**
     * Gets the severity property value. Severity of the malware. Possible values are: unknown, low, moderate, high, severe.
     * @return a WindowsMalwareSeverity
     */
    @jakarta.annotation.Nullable
    public WindowsMalwareSeverity getSeverity() {
        return this.backingStore.get("severity");
    }
    /**
     * Gets the state property value. Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: unknown, detected, cleaned, quarantined, removed, allowed, blocked, cleanFailed, quarantineFailed, removeFailed, allowFailed, abandoned, blockFailed.
     * @return a WindowsMalwareState
     */
    @jakarta.annotation.Nullable
    public WindowsMalwareState getState() {
        return this.backingStore.get("state");
    }
    /**
     * Gets the threatState property value. Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
     * @return a WindowsMalwareThreatState
     */
    @jakarta.annotation.Nullable
    public WindowsMalwareThreatState getThreatState() {
        return this.backingStore.get("threatState");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("additionalInformationUrl", this.getAdditionalInformationUrl());
        writer.writeEnumValue("category", this.getCategory());
        writer.writeIntegerValue("detectionCount", this.getDetectionCount());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeEnumValue("executionState", this.getExecutionState());
        writer.writeOffsetDateTimeValue("initialDetectionDateTime", this.getInitialDetectionDateTime());
        writer.writeOffsetDateTimeValue("lastStateChangeDateTime", this.getLastStateChangeDateTime());
        writer.writeEnumValue("severity", this.getSeverity());
        writer.writeEnumValue("state", this.getState());
        writer.writeEnumValue("threatState", this.getThreatState());
    }
    /**
     * Sets the additionalInformationUrl property value. Information URL to learn more about the malware
     * @param value Value to set for the additionalInformationUrl property.
     */
    public void setAdditionalInformationUrl(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("additionalInformationUrl", value);
    }
    /**
     * Sets the category property value. Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
     * @param value Value to set for the category property.
     */
    public void setCategory(@jakarta.annotation.Nullable final WindowsMalwareCategory value) {
        this.backingStore.set("category", value);
    }
    /**
     * Sets the detectionCount property value. Number of times the malware is detected
     * @param value Value to set for the detectionCount property.
     */
    public void setDetectionCount(@jakarta.annotation.Nullable final Integer value) {
        this.backingStore.set("detectionCount", value);
    }
    /**
     * Sets the displayName property value. Malware name
     * @param value Value to set for the displayName property.
     */
    public void setDisplayName(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("displayName", value);
    }
    /**
     * Sets the executionState property value. Execution status of the malware like blocked/executing etc. Possible values are: unknown, blocked, allowed, running, notRunning.
     * @param value Value to set for the executionState property.
     */
    public void setExecutionState(@jakarta.annotation.Nullable final WindowsMalwareExecutionState value) {
        this.backingStore.set("executionState", value);
    }
    /**
     * Sets the initialDetectionDateTime property value. Initial detection datetime of the malware
     * @param value Value to set for the initialDetectionDateTime property.
     */
    public void setInitialDetectionDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("initialDetectionDateTime", value);
    }
    /**
     * Sets the lastStateChangeDateTime property value. The last time this particular threat was changed
     * @param value Value to set for the lastStateChangeDateTime property.
     */
    public void setLastStateChangeDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("lastStateChangeDateTime", value);
    }
    /**
     * Sets the severity property value. Severity of the malware. Possible values are: unknown, low, moderate, high, severe.
     * @param value Value to set for the severity property.
     */
    public void setSeverity(@jakarta.annotation.Nullable final WindowsMalwareSeverity value) {
        this.backingStore.set("severity", value);
    }
    /**
     * Sets the state property value. Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: unknown, detected, cleaned, quarantined, removed, allowed, blocked, cleanFailed, quarantineFailed, removeFailed, allowFailed, abandoned, blockFailed.
     * @param value Value to set for the state property.
     */
    public void setState(@jakarta.annotation.Nullable final WindowsMalwareState value) {
        this.backingStore.set("state", value);
    }
    /**
     * Sets the threatState property value. Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
     * @param value Value to set for the threatState property.
     */
    public void setThreatState(@jakarta.annotation.Nullable final WindowsMalwareThreatState value) {
        this.backingStore.set("threatState", value);
    }
}
