package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
@jakarta.annotation.Generated("com.microsoft.kiota")
public class VulnerabilityState implements AdditionalDataHolder, BackedModel, Parsable {
    /**
     * Stores model information.
     */
    @jakarta.annotation.Nonnull
    protected BackingStore backingStore;
    /**
     * Instantiates a new VulnerabilityState and sets the default values.
     */
    public VulnerabilityState() {
        this.backingStore = BackingStoreFactorySingleton.instance.createBackingStore();
        this.setAdditionalData(new HashMap<>());
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a VulnerabilityState
     */
    @jakarta.annotation.Nonnull
    public static VulnerabilityState createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new VulnerabilityState();
    }
    /**
     * Gets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @return a Map<String, Object>
     */
    @jakarta.annotation.Nonnull
    public Map<String, Object> getAdditionalData() {
        Map<String, Object> value = this.backingStore.get("additionalData");
        if(value == null) {
            value = new HashMap<>();
            this.setAdditionalData(value);
        }
        return value;
    }
    /**
     * Gets the backingStore property value. Stores model information.
     * @return a BackingStore
     */
    @jakarta.annotation.Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }
    /**
     * Gets the cve property value. Common Vulnerabilities and Exposures (CVE) for the vulnerability.
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getCve() {
        return this.backingStore.get("cve");
    }
    /**
     * The deserialization information for the current model
     * @return a Map<String, java.util.function.Consumer<ParseNode>>
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(4);
        deserializerMap.put("cve", (n) -> { this.setCve(n.getStringValue()); });
        deserializerMap.put("@odata.type", (n) -> { this.setOdataType(n.getStringValue()); });
        deserializerMap.put("severity", (n) -> { this.setSeverity(n.getStringValue()); });
        deserializerMap.put("wasRunning", (n) -> { this.setWasRunning(n.getBooleanValue()); });
        return deserializerMap;
    }
    /**
     * Gets the @odata.type property value. The OdataType property
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getOdataType() {
        return this.backingStore.get("odataType");
    }
    /**
     * Gets the severity property value. Base Common Vulnerability Scoring System (CVSS) severity score for this vulnerability.
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getSeverity() {
        return this.backingStore.get("severity");
    }
    /**
     * Gets the wasRunning property value. Indicates whether the detected vulnerability (file) was running at the time of detection or was the file detected at rest on the disk.
     * @return a Boolean
     */
    @jakarta.annotation.Nullable
    public Boolean getWasRunning() {
        return this.backingStore.get("wasRunning");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("cve", this.getCve());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("severity", this.getSeverity());
        writer.writeBooleanValue("wasRunning", this.getWasRunning());
        writer.writeAdditionalData(this.getAdditionalData());
    }
    /**
     * Sets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @param value Value to set for the AdditionalData property.
     */
    public void setAdditionalData(@jakarta.annotation.Nullable final Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }
    /**
     * Sets the backingStore property value. Stores model information.
     * @param value Value to set for the backingStore property.
     */
    public void setBackingStore(@jakarta.annotation.Nonnull final BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }
    /**
     * Sets the cve property value. Common Vulnerabilities and Exposures (CVE) for the vulnerability.
     * @param value Value to set for the cve property.
     */
    public void setCve(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("cve", value);
    }
    /**
     * Sets the @odata.type property value. The OdataType property
     * @param value Value to set for the @odata.type property.
     */
    public void setOdataType(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("odataType", value);
    }
    /**
     * Sets the severity property value. Base Common Vulnerability Scoring System (CVSS) severity score for this vulnerability.
     * @param value Value to set for the severity property.
     */
    public void setSeverity(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("severity", value);
    }
    /**
     * Sets the wasRunning property value. Indicates whether the detected vulnerability (file) was running at the time of detection or was the file detected at rest on the disk.
     * @param value Value to set for the wasRunning property.
     */
    public void setWasRunning(@jakarta.annotation.Nullable final Boolean value) {
        this.backingStore.set("wasRunning", value);
    }
}
