// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookWorksheet;
import com.microsoft.graph.models.WorkbookRange;
import com.microsoft.graph.requests.WorkbookChartCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartRequestBuilder;
import com.microsoft.graph.requests.WorkbookNamedItemCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookNamedItemRequestBuilder;
import com.microsoft.graph.requests.WorkbookPivotTableCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookPivotTableRequestBuilder;
import com.microsoft.graph.requests.WorkbookWorksheetProtectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Worksheet Request.
 */
public class WorkbookWorksheetRequest extends BaseRequest<WorkbookWorksheet> {
	
    /**
     * The request for the WorkbookWorksheet
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookWorksheetRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookWorksheet.class);
    }

    /**
     * Gets the WorkbookWorksheet from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookWorksheet> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookWorksheet from the service
     *
     * @return the WorkbookWorksheet from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookWorksheet get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookWorksheet> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookWorksheet delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookWorksheet with a source
     *
     * @param sourceWorkbookWorksheet the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookWorksheet> patchAsync(@Nonnull final WorkbookWorksheet sourceWorkbookWorksheet) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookWorksheet);
    }

    /**
     * Patches this WorkbookWorksheet with a source
     *
     * @param sourceWorkbookWorksheet the source object with updates
     * @return the updated WorkbookWorksheet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookWorksheet patch(@Nonnull final WorkbookWorksheet sourceWorkbookWorksheet) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookWorksheet);
    }

    /**
     * Creates a WorkbookWorksheet with a new object
     *
     * @param newWorkbookWorksheet the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookWorksheet> postAsync(@Nonnull final WorkbookWorksheet newWorkbookWorksheet) {
        return sendAsync(HttpMethod.POST, newWorkbookWorksheet);
    }

    /**
     * Creates a WorkbookWorksheet with a new object
     *
     * @param newWorkbookWorksheet the new object to create
     * @return the created WorkbookWorksheet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookWorksheet post(@Nonnull final WorkbookWorksheet newWorkbookWorksheet) throws ClientException {
        return send(HttpMethod.POST, newWorkbookWorksheet);
    }

    /**
     * Creates a WorkbookWorksheet with a new object
     *
     * @param newWorkbookWorksheet the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookWorksheet> putAsync(@Nonnull final WorkbookWorksheet newWorkbookWorksheet) {
        return sendAsync(HttpMethod.PUT, newWorkbookWorksheet);
    }

    /**
     * Creates a WorkbookWorksheet with a new object
     *
     * @param newWorkbookWorksheet the object to create/update
     * @return the created WorkbookWorksheet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookWorksheet put(@Nonnull final WorkbookWorksheet newWorkbookWorksheet) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookWorksheet);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookWorksheetRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookWorksheetRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

