// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ServiceUpdateMessage;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Update Message Request.
 */
public class ServiceUpdateMessageRequest extends BaseRequest<ServiceUpdateMessage> {
	
    /**
     * The request for the ServiceUpdateMessage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ServiceUpdateMessageRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ServiceUpdateMessage.class);
    }

    /**
     * Gets the ServiceUpdateMessage from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceUpdateMessage> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ServiceUpdateMessage from the service
     *
     * @return the ServiceUpdateMessage from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceUpdateMessage get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceUpdateMessage> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ServiceUpdateMessage delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ServiceUpdateMessage with a source
     *
     * @param sourceServiceUpdateMessage the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceUpdateMessage> patchAsync(@Nonnull final ServiceUpdateMessage sourceServiceUpdateMessage) {
        return sendAsync(HttpMethod.PATCH, sourceServiceUpdateMessage);
    }

    /**
     * Patches this ServiceUpdateMessage with a source
     *
     * @param sourceServiceUpdateMessage the source object with updates
     * @return the updated ServiceUpdateMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceUpdateMessage patch(@Nonnull final ServiceUpdateMessage sourceServiceUpdateMessage) throws ClientException {
        return send(HttpMethod.PATCH, sourceServiceUpdateMessage);
    }

    /**
     * Creates a ServiceUpdateMessage with a new object
     *
     * @param newServiceUpdateMessage the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceUpdateMessage> postAsync(@Nonnull final ServiceUpdateMessage newServiceUpdateMessage) {
        return sendAsync(HttpMethod.POST, newServiceUpdateMessage);
    }

    /**
     * Creates a ServiceUpdateMessage with a new object
     *
     * @param newServiceUpdateMessage the new object to create
     * @return the created ServiceUpdateMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceUpdateMessage post(@Nonnull final ServiceUpdateMessage newServiceUpdateMessage) throws ClientException {
        return send(HttpMethod.POST, newServiceUpdateMessage);
    }

    /**
     * Creates a ServiceUpdateMessage with a new object
     *
     * @param newServiceUpdateMessage the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceUpdateMessage> putAsync(@Nonnull final ServiceUpdateMessage newServiceUpdateMessage) {
        return sendAsync(HttpMethod.PUT, newServiceUpdateMessage);
    }

    /**
     * Creates a ServiceUpdateMessage with a new object
     *
     * @param newServiceUpdateMessage the object to create/update
     * @return the created ServiceUpdateMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceUpdateMessage put(@Nonnull final ServiceUpdateMessage newServiceUpdateMessage) throws ClientException {
        return send(HttpMethod.PUT, newServiceUpdateMessage);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ServiceUpdateMessageRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ServiceUpdateMessageRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

