// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrintJob;
import com.microsoft.graph.models.PrintJobConfiguration;
import com.microsoft.graph.models.PrintJobStatus;
import com.microsoft.graph.requests.PrintDocumentCollectionRequestBuilder;
import com.microsoft.graph.requests.PrintDocumentRequestBuilder;
import com.microsoft.graph.requests.PrintTaskCollectionRequestBuilder;
import com.microsoft.graph.requests.PrintTaskRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Job Request.
 */
public class PrintJobRequest extends BaseRequest<PrintJob> {
	
    /**
     * The request for the PrintJob
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintJobRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintJob.class);
    }

    /**
     * Gets the PrintJob from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintJob> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrintJob from the service
     *
     * @return the PrintJob from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintJob get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintJob> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrintJob delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrintJob with a source
     *
     * @param sourcePrintJob the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintJob> patchAsync(@Nonnull final PrintJob sourcePrintJob) {
        return sendAsync(HttpMethod.PATCH, sourcePrintJob);
    }

    /**
     * Patches this PrintJob with a source
     *
     * @param sourcePrintJob the source object with updates
     * @return the updated PrintJob
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintJob patch(@Nonnull final PrintJob sourcePrintJob) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrintJob);
    }

    /**
     * Creates a PrintJob with a new object
     *
     * @param newPrintJob the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintJob> postAsync(@Nonnull final PrintJob newPrintJob) {
        return sendAsync(HttpMethod.POST, newPrintJob);
    }

    /**
     * Creates a PrintJob with a new object
     *
     * @param newPrintJob the new object to create
     * @return the created PrintJob
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintJob post(@Nonnull final PrintJob newPrintJob) throws ClientException {
        return send(HttpMethod.POST, newPrintJob);
    }

    /**
     * Creates a PrintJob with a new object
     *
     * @param newPrintJob the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintJob> putAsync(@Nonnull final PrintJob newPrintJob) {
        return sendAsync(HttpMethod.PUT, newPrintJob);
    }

    /**
     * Creates a PrintJob with a new object
     *
     * @param newPrintJob the object to create/update
     * @return the created PrintJob
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintJob put(@Nonnull final PrintJob newPrintJob) throws ClientException {
        return send(HttpMethod.PUT, newPrintJob);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrintJobRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrintJobRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

