// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Sharepoint Ids.
 */
public class SharepointIds implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The List Id.
     * The unique identifier (guid) for the item's list in SharePoint.
     */
    @SerializedName(value = "listId", alternate = {"ListId"})
    @Expose
	@Nullable
    public String listId;

    /**
     * The List Item Id.
     * An integer identifier for the item within the containing list.
     */
    @SerializedName(value = "listItemId", alternate = {"ListItemId"})
    @Expose
	@Nullable
    public String listItemId;

    /**
     * The List Item Unique Id.
     * The unique identifier (guid) for the item within OneDrive for Business or a SharePoint site.
     */
    @SerializedName(value = "listItemUniqueId", alternate = {"ListItemUniqueId"})
    @Expose
	@Nullable
    public String listItemUniqueId;

    /**
     * The Site Id.
     * The unique identifier (guid) for the item's site collection (SPSite).
     */
    @SerializedName(value = "siteId", alternate = {"SiteId"})
    @Expose
	@Nullable
    public String siteId;

    /**
     * The Site Url.
     * The SharePoint URL for the site that contains the item.
     */
    @SerializedName(value = "siteUrl", alternate = {"SiteUrl"})
    @Expose
	@Nullable
    public String siteUrl;

    /**
     * The Tenant Id.
     * The unique identifier (guid) for the tenancy.
     */
    @SerializedName(value = "tenantId", alternate = {"TenantId"})
    @Expose
	@Nullable
    public String tenantId;

    /**
     * The Web Id.
     * The unique identifier (guid) for the item's site (SPWeb).
     */
    @SerializedName(value = "webId", alternate = {"WebId"})
    @Expose
	@Nullable
    public String webId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
