// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.AzureResourceEvidence;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Sas Token Evidence.
 */
public class SasTokenEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Allowed Ip Addresses.
     * 
     */
    @SerializedName(value = "allowedIpAddresses", alternate = {"AllowedIpAddresses"})
    @Expose
	@Nullable
    public String allowedIpAddresses;

    /**
     * The Allowed Resource Types.
     * 
     */
    @SerializedName(value = "allowedResourceTypes", alternate = {"AllowedResourceTypes"})
    @Expose
	@Nullable
    public java.util.List<String> allowedResourceTypes;

    /**
     * The Allowed Services.
     * 
     */
    @SerializedName(value = "allowedServices", alternate = {"AllowedServices"})
    @Expose
	@Nullable
    public java.util.List<String> allowedServices;

    /**
     * The Expiry Date Time.
     * 
     */
    @SerializedName(value = "expiryDateTime", alternate = {"ExpiryDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime expiryDateTime;

    /**
     * The Permissions.
     * 
     */
    @SerializedName(value = "permissions", alternate = {"Permissions"})
    @Expose
	@Nullable
    public java.util.List<String> permissions;

    /**
     * The Protocol.
     * 
     */
    @SerializedName(value = "protocol", alternate = {"Protocol"})
    @Expose
	@Nullable
    public String protocol;

    /**
     * The Signature Hash.
     * 
     */
    @SerializedName(value = "signatureHash", alternate = {"SignatureHash"})
    @Expose
	@Nullable
    public String signatureHash;

    /**
     * The Signed With.
     * 
     */
    @SerializedName(value = "signedWith", alternate = {"SignedWith"})
    @Expose
	@Nullable
    public String signedWith;

    /**
     * The Start Date Time.
     * 
     */
    @SerializedName(value = "startDateTime", alternate = {"StartDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime startDateTime;

    /**
     * The Storage Resource.
     * 
     */
    @SerializedName(value = "storageResource", alternate = {"StorageResource"})
    @Expose
	@Nullable
    public AzureResourceEvidence storageResource;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
