// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.IpEvidence;
import com.microsoft.graph.security.models.ProtocolType;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Network Connection Evidence.
 */
public class NetworkConnectionEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Destination Address.
     * 
     */
    @SerializedName(value = "destinationAddress", alternate = {"DestinationAddress"})
    @Expose
	@Nullable
    public IpEvidence destinationAddress;

    /**
     * The Destination Port.
     * 
     */
    @SerializedName(value = "destinationPort", alternate = {"DestinationPort"})
    @Expose
	@Nullable
    public Integer destinationPort;

    /**
     * The Protocol.
     * 
     */
    @SerializedName(value = "protocol", alternate = {"Protocol"})
    @Expose
	@Nullable
    public ProtocolType protocol;

    /**
     * The Source Address.
     * 
     */
    @SerializedName(value = "sourceAddress", alternate = {"SourceAddress"})
    @Expose
	@Nullable
    public IpEvidence sourceAddress;

    /**
     * The Source Port.
     * 
     */
    @SerializedName(value = "sourcePort", alternate = {"SourcePort"})
    @Expose
	@Nullable
    public Integer sourcePort;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
