// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.IoTDeviceImportanceType;
import com.microsoft.graph.security.models.AzureResourceEvidence;
import com.microsoft.graph.security.models.IpEvidence;
import com.microsoft.graph.security.models.NicEvidence;
import com.microsoft.graph.security.models.UrlEvidence;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Io TDevice Evidence.
 */
public class IoTDeviceEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Device Id.
     * 
     */
    @SerializedName(value = "deviceId", alternate = {"DeviceId"})
    @Expose
	@Nullable
    public String deviceId;

    /**
     * The Device Name.
     * 
     */
    @SerializedName(value = "deviceName", alternate = {"DeviceName"})
    @Expose
	@Nullable
    public String deviceName;

    /**
     * The Device Page Link.
     * 
     */
    @SerializedName(value = "devicePageLink", alternate = {"DevicePageLink"})
    @Expose
	@Nullable
    public String devicePageLink;

    /**
     * The Device Sub Type.
     * 
     */
    @SerializedName(value = "deviceSubType", alternate = {"DeviceSubType"})
    @Expose
	@Nullable
    public String deviceSubType;

    /**
     * The Device Type.
     * 
     */
    @SerializedName(value = "deviceType", alternate = {"DeviceType"})
    @Expose
	@Nullable
    public String deviceType;

    /**
     * The Importance.
     * 
     */
    @SerializedName(value = "importance", alternate = {"Importance"})
    @Expose
	@Nullable
    public IoTDeviceImportanceType importance;

    /**
     * The Io THub.
     * 
     */
    @SerializedName(value = "ioTHub", alternate = {"IoTHub"})
    @Expose
	@Nullable
    public AzureResourceEvidence ioTHub;

    /**
     * The Io TSecurity Agent Id.
     * 
     */
    @SerializedName(value = "ioTSecurityAgentId", alternate = {"IoTSecurityAgentId"})
    @Expose
	@Nullable
    public String ioTSecurityAgentId;

    /**
     * The Ip Address.
     * 
     */
    @SerializedName(value = "ipAddress", alternate = {"IpAddress"})
    @Expose
	@Nullable
    public IpEvidence ipAddress;

    /**
     * The Is Authorized.
     * 
     */
    @SerializedName(value = "isAuthorized", alternate = {"IsAuthorized"})
    @Expose
	@Nullable
    public Boolean isAuthorized;

    /**
     * The Is Programming.
     * 
     */
    @SerializedName(value = "isProgramming", alternate = {"IsProgramming"})
    @Expose
	@Nullable
    public Boolean isProgramming;

    /**
     * The Is Scanner.
     * 
     */
    @SerializedName(value = "isScanner", alternate = {"IsScanner"})
    @Expose
	@Nullable
    public Boolean isScanner;

    /**
     * The Mac Address.
     * 
     */
    @SerializedName(value = "macAddress", alternate = {"MacAddress"})
    @Expose
	@Nullable
    public String macAddress;

    /**
     * The Manufacturer.
     * 
     */
    @SerializedName(value = "manufacturer", alternate = {"Manufacturer"})
    @Expose
	@Nullable
    public String manufacturer;

    /**
     * The Model.
     * 
     */
    @SerializedName(value = "model", alternate = {"Model"})
    @Expose
	@Nullable
    public String model;

    /**
     * The Nics.
     * 
     */
    @SerializedName(value = "nics", alternate = {"Nics"})
    @Expose
	@Nullable
    public NicEvidence nics;

    /**
     * The Operating System.
     * 
     */
    @SerializedName(value = "operatingSystem", alternate = {"OperatingSystem"})
    @Expose
	@Nullable
    public String operatingSystem;

    /**
     * The Owners.
     * 
     */
    @SerializedName(value = "owners", alternate = {"Owners"})
    @Expose
	@Nullable
    public java.util.List<String> owners;

    /**
     * The Protocols.
     * 
     */
    @SerializedName(value = "protocols", alternate = {"Protocols"})
    @Expose
	@Nullable
    public java.util.List<String> protocols;

    /**
     * The Purdue Layer.
     * 
     */
    @SerializedName(value = "purdueLayer", alternate = {"PurdueLayer"})
    @Expose
	@Nullable
    public String purdueLayer;

    /**
     * The Sensor.
     * 
     */
    @SerializedName(value = "sensor", alternate = {"Sensor"})
    @Expose
	@Nullable
    public String sensor;

    /**
     * The Serial Number.
     * 
     */
    @SerializedName(value = "serialNumber", alternate = {"SerialNumber"})
    @Expose
	@Nullable
    public String serialNumber;

    /**
     * The Site.
     * 
     */
    @SerializedName(value = "site", alternate = {"Site"})
    @Expose
	@Nullable
    public String site;

    /**
     * The Source.
     * 
     */
    @SerializedName(value = "source", alternate = {"Source"})
    @Expose
	@Nullable
    public String source;

    /**
     * The Source Ref.
     * 
     */
    @SerializedName(value = "sourceRef", alternate = {"SourceRef"})
    @Expose
	@Nullable
    public UrlEvidence sourceRef;

    /**
     * The Zone.
     * 
     */
    @SerializedName(value = "zone", alternate = {"Zone"})
    @Expose
	@Nullable
    public String zone;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
