// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.UserEvidence;
import com.microsoft.graph.security.models.DeviceEvidence;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Logon Session Evidence.
 */
public class HostLogonSessionEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Account.
     * 
     */
    @SerializedName(value = "account", alternate = {"Account"})
    @Expose
	@Nullable
    public UserEvidence account;

    /**
     * The End Utc Date Time.
     * 
     */
    @SerializedName(value = "endUtcDateTime", alternate = {"EndUtcDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime endUtcDateTime;

    /**
     * The Host.
     * 
     */
    @SerializedName(value = "host", alternate = {"Host"})
    @Expose
	@Nullable
    public DeviceEvidence host;

    /**
     * The Session Id.
     * 
     */
    @SerializedName(value = "sessionId", alternate = {"SessionId"})
    @Expose
	@Nullable
    public String sessionId;

    /**
     * The Start Utc Date Time.
     * 
     */
    @SerializedName(value = "startUtcDateTime", alternate = {"StartUtcDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime startUtcDateTime;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
