// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SendDtmfTonesOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Send Dtmf Tones Operation Request.
 */
public class SendDtmfTonesOperationRequest extends BaseRequest<SendDtmfTonesOperation> {
	
    /**
     * The request for the SendDtmfTonesOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SendDtmfTonesOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SendDtmfTonesOperation.class);
    }

    /**
     * Gets the SendDtmfTonesOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SendDtmfTonesOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SendDtmfTonesOperation from the service
     *
     * @return the SendDtmfTonesOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SendDtmfTonesOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SendDtmfTonesOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SendDtmfTonesOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SendDtmfTonesOperation with a source
     *
     * @param sourceSendDtmfTonesOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SendDtmfTonesOperation> patchAsync(@Nonnull final SendDtmfTonesOperation sourceSendDtmfTonesOperation) {
        return sendAsync(HttpMethod.PATCH, sourceSendDtmfTonesOperation);
    }

    /**
     * Patches this SendDtmfTonesOperation with a source
     *
     * @param sourceSendDtmfTonesOperation the source object with updates
     * @return the updated SendDtmfTonesOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SendDtmfTonesOperation patch(@Nonnull final SendDtmfTonesOperation sourceSendDtmfTonesOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceSendDtmfTonesOperation);
    }

    /**
     * Creates a SendDtmfTonesOperation with a new object
     *
     * @param newSendDtmfTonesOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SendDtmfTonesOperation> postAsync(@Nonnull final SendDtmfTonesOperation newSendDtmfTonesOperation) {
        return sendAsync(HttpMethod.POST, newSendDtmfTonesOperation);
    }

    /**
     * Creates a SendDtmfTonesOperation with a new object
     *
     * @param newSendDtmfTonesOperation the new object to create
     * @return the created SendDtmfTonesOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SendDtmfTonesOperation post(@Nonnull final SendDtmfTonesOperation newSendDtmfTonesOperation) throws ClientException {
        return send(HttpMethod.POST, newSendDtmfTonesOperation);
    }

    /**
     * Creates a SendDtmfTonesOperation with a new object
     *
     * @param newSendDtmfTonesOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SendDtmfTonesOperation> putAsync(@Nonnull final SendDtmfTonesOperation newSendDtmfTonesOperation) {
        return sendAsync(HttpMethod.PUT, newSendDtmfTonesOperation);
    }

    /**
     * Creates a SendDtmfTonesOperation with a new object
     *
     * @param newSendDtmfTonesOperation the object to create/update
     * @return the created SendDtmfTonesOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SendDtmfTonesOperation put(@Nonnull final SendDtmfTonesOperation newSendDtmfTonesOperation) throws ClientException {
        return send(HttpMethod.PUT, newSendDtmfTonesOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SendDtmfTonesOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SendDtmfTonesOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

