// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrivilegedAccessGroupAssignmentScheduleInstance;
import com.microsoft.graph.models.AssignmentScheduleInstanceFilterByCurrentUserOptions;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Group Assignment Schedule Instance Request.
 */
public class PrivilegedAccessGroupAssignmentScheduleInstanceRequest extends BaseRequest<PrivilegedAccessGroupAssignmentScheduleInstance> {
	
    /**
     * The request for the PrivilegedAccessGroupAssignmentScheduleInstance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrivilegedAccessGroupAssignmentScheduleInstanceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrivilegedAccessGroupAssignmentScheduleInstance.class);
    }

    /**
     * Gets the PrivilegedAccessGroupAssignmentScheduleInstance from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentScheduleInstance> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrivilegedAccessGroupAssignmentScheduleInstance from the service
     *
     * @return the PrivilegedAccessGroupAssignmentScheduleInstance from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentScheduleInstance get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentScheduleInstance> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentScheduleInstance delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrivilegedAccessGroupAssignmentScheduleInstance with a source
     *
     * @param sourcePrivilegedAccessGroupAssignmentScheduleInstance the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentScheduleInstance> patchAsync(@Nonnull final PrivilegedAccessGroupAssignmentScheduleInstance sourcePrivilegedAccessGroupAssignmentScheduleInstance) {
        return sendAsync(HttpMethod.PATCH, sourcePrivilegedAccessGroupAssignmentScheduleInstance);
    }

    /**
     * Patches this PrivilegedAccessGroupAssignmentScheduleInstance with a source
     *
     * @param sourcePrivilegedAccessGroupAssignmentScheduleInstance the source object with updates
     * @return the updated PrivilegedAccessGroupAssignmentScheduleInstance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentScheduleInstance patch(@Nonnull final PrivilegedAccessGroupAssignmentScheduleInstance sourcePrivilegedAccessGroupAssignmentScheduleInstance) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrivilegedAccessGroupAssignmentScheduleInstance);
    }

    /**
     * Creates a PrivilegedAccessGroupAssignmentScheduleInstance with a new object
     *
     * @param newPrivilegedAccessGroupAssignmentScheduleInstance the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentScheduleInstance> postAsync(@Nonnull final PrivilegedAccessGroupAssignmentScheduleInstance newPrivilegedAccessGroupAssignmentScheduleInstance) {
        return sendAsync(HttpMethod.POST, newPrivilegedAccessGroupAssignmentScheduleInstance);
    }

    /**
     * Creates a PrivilegedAccessGroupAssignmentScheduleInstance with a new object
     *
     * @param newPrivilegedAccessGroupAssignmentScheduleInstance the new object to create
     * @return the created PrivilegedAccessGroupAssignmentScheduleInstance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentScheduleInstance post(@Nonnull final PrivilegedAccessGroupAssignmentScheduleInstance newPrivilegedAccessGroupAssignmentScheduleInstance) throws ClientException {
        return send(HttpMethod.POST, newPrivilegedAccessGroupAssignmentScheduleInstance);
    }

    /**
     * Creates a PrivilegedAccessGroupAssignmentScheduleInstance with a new object
     *
     * @param newPrivilegedAccessGroupAssignmentScheduleInstance the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentScheduleInstance> putAsync(@Nonnull final PrivilegedAccessGroupAssignmentScheduleInstance newPrivilegedAccessGroupAssignmentScheduleInstance) {
        return sendAsync(HttpMethod.PUT, newPrivilegedAccessGroupAssignmentScheduleInstance);
    }

    /**
     * Creates a PrivilegedAccessGroupAssignmentScheduleInstance with a new object
     *
     * @param newPrivilegedAccessGroupAssignmentScheduleInstance the object to create/update
     * @return the created PrivilegedAccessGroupAssignmentScheduleInstance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentScheduleInstance put(@Nonnull final PrivilegedAccessGroupAssignmentScheduleInstance newPrivilegedAccessGroupAssignmentScheduleInstance) throws ClientException {
        return send(HttpMethod.PUT, newPrivilegedAccessGroupAssignmentScheduleInstance);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrivilegedAccessGroupAssignmentScheduleInstanceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrivilegedAccessGroupAssignmentScheduleInstanceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

