// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.OnlineMeetingBase;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Online Meeting Base Request.
 */
public class OnlineMeetingBaseRequest extends BaseRequest<OnlineMeetingBase> {
	
    /**
     * The request for the OnlineMeetingBase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public OnlineMeetingBaseRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends OnlineMeetingBase> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the OnlineMeetingBase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OnlineMeetingBaseRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OnlineMeetingBase.class);
    }

    /**
     * Gets the OnlineMeetingBase from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnlineMeetingBase> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the OnlineMeetingBase from the service
     *
     * @return the OnlineMeetingBase from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnlineMeetingBase get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnlineMeetingBase> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public OnlineMeetingBase delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OnlineMeetingBase with a source
     *
     * @param sourceOnlineMeetingBase the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnlineMeetingBase> patchAsync(@Nonnull final OnlineMeetingBase sourceOnlineMeetingBase) {
        return sendAsync(HttpMethod.PATCH, sourceOnlineMeetingBase);
    }

    /**
     * Patches this OnlineMeetingBase with a source
     *
     * @param sourceOnlineMeetingBase the source object with updates
     * @return the updated OnlineMeetingBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnlineMeetingBase patch(@Nonnull final OnlineMeetingBase sourceOnlineMeetingBase) throws ClientException {
        return send(HttpMethod.PATCH, sourceOnlineMeetingBase);
    }

    /**
     * Creates a OnlineMeetingBase with a new object
     *
     * @param newOnlineMeetingBase the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnlineMeetingBase> postAsync(@Nonnull final OnlineMeetingBase newOnlineMeetingBase) {
        return sendAsync(HttpMethod.POST, newOnlineMeetingBase);
    }

    /**
     * Creates a OnlineMeetingBase with a new object
     *
     * @param newOnlineMeetingBase the new object to create
     * @return the created OnlineMeetingBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnlineMeetingBase post(@Nonnull final OnlineMeetingBase newOnlineMeetingBase) throws ClientException {
        return send(HttpMethod.POST, newOnlineMeetingBase);
    }

    /**
     * Creates a OnlineMeetingBase with a new object
     *
     * @param newOnlineMeetingBase the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OnlineMeetingBase> putAsync(@Nonnull final OnlineMeetingBase newOnlineMeetingBase) {
        return sendAsync(HttpMethod.PUT, newOnlineMeetingBase);
    }

    /**
     * Creates a OnlineMeetingBase with a new object
     *
     * @param newOnlineMeetingBase the object to create/update
     * @return the created OnlineMeetingBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OnlineMeetingBase put(@Nonnull final OnlineMeetingBase newOnlineMeetingBase) throws ClientException {
        return send(HttpMethod.PUT, newOnlineMeetingBase);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public OnlineMeetingBaseRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public OnlineMeetingBaseRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

