// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationGradingCategory;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Grading Category Request.
 */
public class EducationGradingCategoryRequest extends BaseRequest<EducationGradingCategory> {
	
    /**
     * The request for the EducationGradingCategory
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationGradingCategoryRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationGradingCategory.class);
    }

    /**
     * Gets the EducationGradingCategory from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationGradingCategory> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EducationGradingCategory from the service
     *
     * @return the EducationGradingCategory from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationGradingCategory get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationGradingCategory> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EducationGradingCategory delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EducationGradingCategory with a source
     *
     * @param sourceEducationGradingCategory the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationGradingCategory> patchAsync(@Nonnull final EducationGradingCategory sourceEducationGradingCategory) {
        return sendAsync(HttpMethod.PATCH, sourceEducationGradingCategory);
    }

    /**
     * Patches this EducationGradingCategory with a source
     *
     * @param sourceEducationGradingCategory the source object with updates
     * @return the updated EducationGradingCategory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationGradingCategory patch(@Nonnull final EducationGradingCategory sourceEducationGradingCategory) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationGradingCategory);
    }

    /**
     * Creates a EducationGradingCategory with a new object
     *
     * @param newEducationGradingCategory the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationGradingCategory> postAsync(@Nonnull final EducationGradingCategory newEducationGradingCategory) {
        return sendAsync(HttpMethod.POST, newEducationGradingCategory);
    }

    /**
     * Creates a EducationGradingCategory with a new object
     *
     * @param newEducationGradingCategory the new object to create
     * @return the created EducationGradingCategory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationGradingCategory post(@Nonnull final EducationGradingCategory newEducationGradingCategory) throws ClientException {
        return send(HttpMethod.POST, newEducationGradingCategory);
    }

    /**
     * Creates a EducationGradingCategory with a new object
     *
     * @param newEducationGradingCategory the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationGradingCategory> putAsync(@Nonnull final EducationGradingCategory newEducationGradingCategory) {
        return sendAsync(HttpMethod.PUT, newEducationGradingCategory);
    }

    /**
     * Creates a EducationGradingCategory with a new object
     *
     * @param newEducationGradingCategory the object to create/update
     * @return the created EducationGradingCategory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationGradingCategory put(@Nonnull final EducationGradingCategory newEducationGradingCategory) throws ClientException {
        return send(HttpMethod.PUT, newEducationGradingCategory);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EducationGradingCategoryRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EducationGradingCategoryRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

