// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.WindowsMalwareThreatState;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Malware State Count.
 */
public class WindowsMalwareStateCount implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Device Count.
     * Count of devices with malware detections for this malware State
     */
    @SerializedName(value = "deviceCount", alternate = {"DeviceCount"})
    @Expose
	@Nullable
    public Integer deviceCount;

    /**
     * The Distinct Malware Count.
     * Count of distinct malwares for this malware State. Valid values -2147483648 to 2147483647
     */
    @SerializedName(value = "distinctMalwareCount", alternate = {"DistinctMalwareCount"})
    @Expose
	@Nullable
    public Integer distinctMalwareCount;

    /**
     * The Last Update Date Time.
     * The Timestamp of the last update for the device count in UTC
     */
    @SerializedName(value = "lastUpdateDateTime", alternate = {"LastUpdateDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastUpdateDateTime;

    /**
     * The Malware Detection Count.
     * Count of total malware detections for this malware State. Valid values -2147483648 to 2147483647
     */
    @SerializedName(value = "malwareDetectionCount", alternate = {"MalwareDetectionCount"})
    @Expose
	@Nullable
    public Integer malwareDetectionCount;

    /**
     * The State.
     * Malware Threat State. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared. Defaults to noStatusCleared. Computed. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
     */
    @SerializedName(value = "state", alternate = {"State"})
    @Expose
	@Nullable
    public WindowsMalwareThreatState state;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
