// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.UserDefaultAuthenticationMethod;
import com.microsoft.graph.models.SignInUserType;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Registration Details.
 */
public class UserRegistrationDetails extends Entity implements IJsonBackedObject {


    /**
     * The Is Admin.
     * Indicates whether the user has an admin role in the tenant. This value can be used to check the authentication methods that privileged accounts are registered for and capable of.
     */
    @SerializedName(value = "isAdmin", alternate = {"IsAdmin"})
    @Expose
	@Nullable
    public Boolean isAdmin;

    /**
     * The Is Mfa Capable.
     * Indicates whether the user has registered a strong authentication method for multifactor authentication. The method must be allowed by the authentication methods policy. Supports $filter (eq).
     */
    @SerializedName(value = "isMfaCapable", alternate = {"IsMfaCapable"})
    @Expose
	@Nullable
    public Boolean isMfaCapable;

    /**
     * The Is Mfa Registered.
     * Indicates whether the user has registered a strong authentication method for multifactor authentication. The method may not necessarily be allowed by the authentication methods policy. Supports $filter (eq).
     */
    @SerializedName(value = "isMfaRegistered", alternate = {"IsMfaRegistered"})
    @Expose
	@Nullable
    public Boolean isMfaRegistered;

    /**
     * The Is Passwordless Capable.
     * Indicates whether the user has registered a passwordless strong authentication method (including FIDO2, Windows Hello for Business, and Microsoft Authenticator (Passwordless)) that is allowed by the authentication methods policy. Supports $filter (eq).
     */
    @SerializedName(value = "isPasswordlessCapable", alternate = {"IsPasswordlessCapable"})
    @Expose
	@Nullable
    public Boolean isPasswordlessCapable;

    /**
     * The Is Sspr Capable.
     * Indicates whether the user has registered the required number of authentication methods for self-service password reset and the user is allowed to perform self-service password reset by policy. Supports $filter (eq).
     */
    @SerializedName(value = "isSsprCapable", alternate = {"IsSsprCapable"})
    @Expose
	@Nullable
    public Boolean isSsprCapable;

    /**
     * The Is Sspr Enabled.
     * Indicates whether the user is allowed to perform self-service password reset by policy. The user may not necessarily have registered the required number of authentication methods for self-service password reset. Supports $filter (eq).
     */
    @SerializedName(value = "isSsprEnabled", alternate = {"IsSsprEnabled"})
    @Expose
	@Nullable
    public Boolean isSsprEnabled;

    /**
     * The Is Sspr Registered.
     * Indicates whether the user has registered the required number of authentication methods for self-service password reset. The user may not necessarily be allowed to perform self-service password reset by policy. Supports $filter (eq).
     */
    @SerializedName(value = "isSsprRegistered", alternate = {"IsSsprRegistered"})
    @Expose
	@Nullable
    public Boolean isSsprRegistered;

    /**
     * The Is System Preferred Authentication Method Enabled.
     * Indicates whether system preferred authentication method is enabled. If enabled, the system dynamically determines the most secure authentication method among the methods registered by the user. Supports $filter (eq).
     */
    @SerializedName(value = "isSystemPreferredAuthenticationMethodEnabled", alternate = {"IsSystemPreferredAuthenticationMethodEnabled"})
    @Expose
	@Nullable
    public Boolean isSystemPreferredAuthenticationMethodEnabled;

    /**
     * The Last Updated Date Time.
     * The date and time (UTC) when the record was last updated. The DateTimeOffset type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "lastUpdatedDateTime", alternate = {"LastUpdatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastUpdatedDateTime;

    /**
     * The Methods Registered.
     * Collection of authentication methods registered, such as mobilePhone, email, passKeyDeviceBound. Supports $filter (any with eq).
     */
    @SerializedName(value = "methodsRegistered", alternate = {"MethodsRegistered"})
    @Expose
	@Nullable
    public java.util.List<String> methodsRegistered;

    /**
     * The System Preferred Authentication Methods.
     * Collection of authentication methods that the system determined to be the most secure authentication methods among the registered methods for second factor authentication. Possible values are: push, oath, voiceMobile, voiceAlternateMobile, voiceOffice, sms, none, unknownFutureValue. Supports $filter (any with eq).
     */
    @SerializedName(value = "systemPreferredAuthenticationMethods", alternate = {"SystemPreferredAuthenticationMethods"})
    @Expose
	@Nullable
    public java.util.List<String> systemPreferredAuthenticationMethods;

    /**
     * The User Display Name.
     * The user display name, such as Adele Vance. Supports $filter (eq, startsWith) and $orderby.
     */
    @SerializedName(value = "userDisplayName", alternate = {"UserDisplayName"})
    @Expose
	@Nullable
    public String userDisplayName;

    /**
     * The User Preferred Method For Secondary Authentication.
     * The method the user selected as the default second-factor for performing multifactor authentication. Possible values are: push, oath, voiceMobile, voiceAlternateMobile, voiceOffice, sms, none, unknownFutureValue. This property is used as preferred MFA method when isSystemPreferredAuthenticationMethodEnabled is false. Supports $filter (any with eq).
     */
    @SerializedName(value = "userPreferredMethodForSecondaryAuthentication", alternate = {"UserPreferredMethodForSecondaryAuthentication"})
    @Expose
	@Nullable
    public UserDefaultAuthenticationMethod userPreferredMethodForSecondaryAuthentication;

    /**
     * The User Principal Name.
     * The user principal name, such as AdeleV@contoso.com. Supports $filter (eq, startsWith) and $orderby.
     */
    @SerializedName(value = "userPrincipalName", alternate = {"UserPrincipalName"})
    @Expose
	@Nullable
    public String userPrincipalName;

    /**
     * The User Type.
     * Identifies whether the user is a member or guest in the tenant. The possible values are: member, guest, unknownFutureValue.
     */
    @SerializedName(value = "userType", alternate = {"UserType"})
    @Expose
	@Nullable
    public SignInUserType userType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
