// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.TimeOffItem;
import com.microsoft.graph.models.ChangeTrackedEntity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Time Off.
 */
public class TimeOff extends ChangeTrackedEntity implements IJsonBackedObject {


    /**
     * The Draft Time Off.
     * The draft version of this timeOff item that is viewable by managers. It must be shared before it is visible to team members. Required.
     */
    @SerializedName(value = "draftTimeOff", alternate = {"DraftTimeOff"})
    @Expose
	@Nullable
    public TimeOffItem draftTimeOff;

    /**
     * The Shared Time Off.
     * The shared version of this timeOff that is viewable by both employees and managers. Updates to the sharedTimeOff property send notifications to users in the Teams client. Required.
     */
    @SerializedName(value = "sharedTimeOff", alternate = {"SharedTimeOff"})
    @Expose
	@Nullable
    public TimeOffItem sharedTimeOff;

    /**
     * The User Id.
     * ID of the user assigned to the timeOff. Required.
     */
    @SerializedName(value = "userId", alternate = {"UserId"})
    @Expose
	@Nullable
    public String userId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
