// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.IdentitySet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Publication Facet.
 */
public class PublicationFacet implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Checked Out By.
     * The user who checked out the file.
     */
    @SerializedName(value = "checkedOutBy", alternate = {"CheckedOutBy"})
    @Expose
	@Nullable
    public IdentitySet checkedOutBy;

    /**
     * The Level.
     * The state of publication for this document. Either published or checkout. Read-only.
     */
    @SerializedName(value = "level", alternate = {"Level"})
    @Expose
	@Nullable
    public String level;

    /**
     * The Version Id.
     * The unique identifier for the version that is visible to the current caller. Read-only.
     */
    @SerializedName(value = "versionId", alternate = {"VersionId"})
    @Expose
	@Nullable
    public String versionId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
