// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.models;

import com.microsoft.graph.models.User;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workflow Activate Parameter Set.
 */
public class WorkflowActivateParameterSet {
    /**
     * The subjects.
     * 
     */
    @SerializedName(value = "subjects", alternate = {"Subjects"})
    @Expose
	@Nullable
    public java.util.List<User> subjects;


    /**
     * Instiaciates a new WorkflowActivateParameterSet
     */
    public WorkflowActivateParameterSet() {}
    /**
     * Instiaciates a new WorkflowActivateParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkflowActivateParameterSet(@Nonnull final WorkflowActivateParameterSetBuilder builder) {
        this.subjects = builder.subjects;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkflowActivateParameterSetBuilder newBuilder() {
        return new WorkflowActivateParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkflowActivateParameterSet
     */
    public static final class WorkflowActivateParameterSetBuilder {
        /**
         * The subjects parameter value
         */
        @Nullable
        protected java.util.List<User> subjects;
        /**
         * Sets the Subjects
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkflowActivateParameterSetBuilder withSubjects(@Nullable final java.util.List<User> val) {
            this.subjects = val;
            return this;
        }
        /**
         * Instanciates a new WorkflowActivateParameterSetBuilder
         */
        @Nullable
        protected WorkflowActivateParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkflowActivateParameterSet build() {
            return new WorkflowActivateParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.subjects != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("subjects", subjects));
        }
        return result;
    }
}
