// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookChartAxisFormat;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Axis Format Request.
 */
public class WorkbookChartAxisFormatRequest extends BaseRequest<WorkbookChartAxisFormat> {
	
    /**
     * The request for the WorkbookChartAxisFormat
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartAxisFormatRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookChartAxisFormat.class);
    }

    /**
     * Gets the WorkbookChartAxisFormat from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartAxisFormat> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookChartAxisFormat from the service
     *
     * @return the WorkbookChartAxisFormat from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartAxisFormat get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartAxisFormat> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookChartAxisFormat delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookChartAxisFormat with a source
     *
     * @param sourceWorkbookChartAxisFormat the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartAxisFormat> patchAsync(@Nonnull final WorkbookChartAxisFormat sourceWorkbookChartAxisFormat) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookChartAxisFormat);
    }

    /**
     * Patches this WorkbookChartAxisFormat with a source
     *
     * @param sourceWorkbookChartAxisFormat the source object with updates
     * @return the updated WorkbookChartAxisFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartAxisFormat patch(@Nonnull final WorkbookChartAxisFormat sourceWorkbookChartAxisFormat) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChartAxisFormat);
    }

    /**
     * Creates a WorkbookChartAxisFormat with a new object
     *
     * @param newWorkbookChartAxisFormat the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartAxisFormat> postAsync(@Nonnull final WorkbookChartAxisFormat newWorkbookChartAxisFormat) {
        return sendAsync(HttpMethod.POST, newWorkbookChartAxisFormat);
    }

    /**
     * Creates a WorkbookChartAxisFormat with a new object
     *
     * @param newWorkbookChartAxisFormat the new object to create
     * @return the created WorkbookChartAxisFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartAxisFormat post(@Nonnull final WorkbookChartAxisFormat newWorkbookChartAxisFormat) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChartAxisFormat);
    }

    /**
     * Creates a WorkbookChartAxisFormat with a new object
     *
     * @param newWorkbookChartAxisFormat the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartAxisFormat> putAsync(@Nonnull final WorkbookChartAxisFormat newWorkbookChartAxisFormat) {
        return sendAsync(HttpMethod.PUT, newWorkbookChartAxisFormat);
    }

    /**
     * Creates a WorkbookChartAxisFormat with a new object
     *
     * @param newWorkbookChartAxisFormat the object to create/update
     * @return the created WorkbookChartAxisFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartAxisFormat put(@Nonnull final WorkbookChartAxisFormat newWorkbookChartAxisFormat) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookChartAxisFormat);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookChartAxisFormatRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookChartAxisFormatRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

