// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.VirtualEventsRoot;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Virtual Events Root Request.
 */
public class VirtualEventsRootRequest extends BaseRequest<VirtualEventsRoot> {
	
    /**
     * The request for the VirtualEventsRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public VirtualEventsRootRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, VirtualEventsRoot.class);
    }

    /**
     * Gets the VirtualEventsRoot from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventsRoot> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the VirtualEventsRoot from the service
     *
     * @return the VirtualEventsRoot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventsRoot get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventsRoot> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public VirtualEventsRoot delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this VirtualEventsRoot with a source
     *
     * @param sourceVirtualEventsRoot the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventsRoot> patchAsync(@Nonnull final VirtualEventsRoot sourceVirtualEventsRoot) {
        return sendAsync(HttpMethod.PATCH, sourceVirtualEventsRoot);
    }

    /**
     * Patches this VirtualEventsRoot with a source
     *
     * @param sourceVirtualEventsRoot the source object with updates
     * @return the updated VirtualEventsRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventsRoot patch(@Nonnull final VirtualEventsRoot sourceVirtualEventsRoot) throws ClientException {
        return send(HttpMethod.PATCH, sourceVirtualEventsRoot);
    }

    /**
     * Creates a VirtualEventsRoot with a new object
     *
     * @param newVirtualEventsRoot the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventsRoot> postAsync(@Nonnull final VirtualEventsRoot newVirtualEventsRoot) {
        return sendAsync(HttpMethod.POST, newVirtualEventsRoot);
    }

    /**
     * Creates a VirtualEventsRoot with a new object
     *
     * @param newVirtualEventsRoot the new object to create
     * @return the created VirtualEventsRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventsRoot post(@Nonnull final VirtualEventsRoot newVirtualEventsRoot) throws ClientException {
        return send(HttpMethod.POST, newVirtualEventsRoot);
    }

    /**
     * Creates a VirtualEventsRoot with a new object
     *
     * @param newVirtualEventsRoot the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventsRoot> putAsync(@Nonnull final VirtualEventsRoot newVirtualEventsRoot) {
        return sendAsync(HttpMethod.PUT, newVirtualEventsRoot);
    }

    /**
     * Creates a VirtualEventsRoot with a new object
     *
     * @param newVirtualEventsRoot the object to create/update
     * @return the created VirtualEventsRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventsRoot put(@Nonnull final VirtualEventsRoot newVirtualEventsRoot) throws ClientException {
        return send(HttpMethod.PUT, newVirtualEventsRoot);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public VirtualEventsRootRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public VirtualEventsRootRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

