// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrivilegedAccessGroupAssignmentScheduleRequest;
import com.microsoft.graph.models.AssignmentScheduleRequestFilterByCurrentUserOptions;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Group Assignment Schedule Request Request.
 */
public class PrivilegedAccessGroupAssignmentScheduleRequestRequest extends BaseRequest<PrivilegedAccessGroupAssignmentScheduleRequest> {
	
    /**
     * The request for the PrivilegedAccessGroupAssignmentScheduleRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrivilegedAccessGroupAssignmentScheduleRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrivilegedAccessGroupAssignmentScheduleRequest.class);
    }

    /**
     * Gets the PrivilegedAccessGroupAssignmentScheduleRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentScheduleRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrivilegedAccessGroupAssignmentScheduleRequest from the service
     *
     * @return the PrivilegedAccessGroupAssignmentScheduleRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentScheduleRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentScheduleRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentScheduleRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrivilegedAccessGroupAssignmentScheduleRequest with a source
     *
     * @param sourcePrivilegedAccessGroupAssignmentScheduleRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentScheduleRequest> patchAsync(@Nonnull final PrivilegedAccessGroupAssignmentScheduleRequest sourcePrivilegedAccessGroupAssignmentScheduleRequest) {
        return sendAsync(HttpMethod.PATCH, sourcePrivilegedAccessGroupAssignmentScheduleRequest);
    }

    /**
     * Patches this PrivilegedAccessGroupAssignmentScheduleRequest with a source
     *
     * @param sourcePrivilegedAccessGroupAssignmentScheduleRequest the source object with updates
     * @return the updated PrivilegedAccessGroupAssignmentScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentScheduleRequest patch(@Nonnull final PrivilegedAccessGroupAssignmentScheduleRequest sourcePrivilegedAccessGroupAssignmentScheduleRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrivilegedAccessGroupAssignmentScheduleRequest);
    }

    /**
     * Creates a PrivilegedAccessGroupAssignmentScheduleRequest with a new object
     *
     * @param newPrivilegedAccessGroupAssignmentScheduleRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentScheduleRequest> postAsync(@Nonnull final PrivilegedAccessGroupAssignmentScheduleRequest newPrivilegedAccessGroupAssignmentScheduleRequest) {
        return sendAsync(HttpMethod.POST, newPrivilegedAccessGroupAssignmentScheduleRequest);
    }

    /**
     * Creates a PrivilegedAccessGroupAssignmentScheduleRequest with a new object
     *
     * @param newPrivilegedAccessGroupAssignmentScheduleRequest the new object to create
     * @return the created PrivilegedAccessGroupAssignmentScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentScheduleRequest post(@Nonnull final PrivilegedAccessGroupAssignmentScheduleRequest newPrivilegedAccessGroupAssignmentScheduleRequest) throws ClientException {
        return send(HttpMethod.POST, newPrivilegedAccessGroupAssignmentScheduleRequest);
    }

    /**
     * Creates a PrivilegedAccessGroupAssignmentScheduleRequest with a new object
     *
     * @param newPrivilegedAccessGroupAssignmentScheduleRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroupAssignmentScheduleRequest> putAsync(@Nonnull final PrivilegedAccessGroupAssignmentScheduleRequest newPrivilegedAccessGroupAssignmentScheduleRequest) {
        return sendAsync(HttpMethod.PUT, newPrivilegedAccessGroupAssignmentScheduleRequest);
    }

    /**
     * Creates a PrivilegedAccessGroupAssignmentScheduleRequest with a new object
     *
     * @param newPrivilegedAccessGroupAssignmentScheduleRequest the object to create/update
     * @return the created PrivilegedAccessGroupAssignmentScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroupAssignmentScheduleRequest put(@Nonnull final PrivilegedAccessGroupAssignmentScheduleRequest newPrivilegedAccessGroupAssignmentScheduleRequest) throws ClientException {
        return send(HttpMethod.PUT, newPrivilegedAccessGroupAssignmentScheduleRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrivilegedAccessGroupAssignmentScheduleRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrivilegedAccessGroupAssignmentScheduleRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

