// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.LearningCourseActivity;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Learning Course Activity Request.
 */
public class LearningCourseActivityRequest extends BaseRequest<LearningCourseActivity> {
	
    /**
     * The request for the LearningCourseActivity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public LearningCourseActivityRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends LearningCourseActivity> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the LearningCourseActivity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LearningCourseActivityRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, LearningCourseActivity.class);
    }

    /**
     * Gets the LearningCourseActivity from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningCourseActivity> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the LearningCourseActivity from the service
     *
     * @return the LearningCourseActivity from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningCourseActivity get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningCourseActivity> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public LearningCourseActivity delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this LearningCourseActivity with a source
     *
     * @param sourceLearningCourseActivity the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningCourseActivity> patchAsync(@Nonnull final LearningCourseActivity sourceLearningCourseActivity) {
        return sendAsync(HttpMethod.PATCH, sourceLearningCourseActivity);
    }

    /**
     * Patches this LearningCourseActivity with a source
     *
     * @param sourceLearningCourseActivity the source object with updates
     * @return the updated LearningCourseActivity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningCourseActivity patch(@Nonnull final LearningCourseActivity sourceLearningCourseActivity) throws ClientException {
        return send(HttpMethod.PATCH, sourceLearningCourseActivity);
    }

    /**
     * Creates a LearningCourseActivity with a new object
     *
     * @param newLearningCourseActivity the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningCourseActivity> postAsync(@Nonnull final LearningCourseActivity newLearningCourseActivity) {
        return sendAsync(HttpMethod.POST, newLearningCourseActivity);
    }

    /**
     * Creates a LearningCourseActivity with a new object
     *
     * @param newLearningCourseActivity the new object to create
     * @return the created LearningCourseActivity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningCourseActivity post(@Nonnull final LearningCourseActivity newLearningCourseActivity) throws ClientException {
        return send(HttpMethod.POST, newLearningCourseActivity);
    }

    /**
     * Creates a LearningCourseActivity with a new object
     *
     * @param newLearningCourseActivity the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningCourseActivity> putAsync(@Nonnull final LearningCourseActivity newLearningCourseActivity) {
        return sendAsync(HttpMethod.PUT, newLearningCourseActivity);
    }

    /**
     * Creates a LearningCourseActivity with a new object
     *
     * @param newLearningCourseActivity the object to create/update
     * @return the created LearningCourseActivity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningCourseActivity put(@Nonnull final LearningCourseActivity newLearningCourseActivity) throws ClientException {
        return send(HttpMethod.PUT, newLearningCourseActivity);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public LearningCourseActivityRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public LearningCourseActivityRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

