// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeltaParticipants;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Delta Participants Request.
 */
public class DeltaParticipantsRequest extends BaseRequest<DeltaParticipants> {
	
    /**
     * The request for the DeltaParticipants
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeltaParticipantsRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeltaParticipants.class);
    }

    /**
     * Gets the DeltaParticipants from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeltaParticipants> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DeltaParticipants from the service
     *
     * @return the DeltaParticipants from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeltaParticipants get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeltaParticipants> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DeltaParticipants delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeltaParticipants with a source
     *
     * @param sourceDeltaParticipants the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeltaParticipants> patchAsync(@Nonnull final DeltaParticipants sourceDeltaParticipants) {
        return sendAsync(HttpMethod.PATCH, sourceDeltaParticipants);
    }

    /**
     * Patches this DeltaParticipants with a source
     *
     * @param sourceDeltaParticipants the source object with updates
     * @return the updated DeltaParticipants
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeltaParticipants patch(@Nonnull final DeltaParticipants sourceDeltaParticipants) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeltaParticipants);
    }

    /**
     * Creates a DeltaParticipants with a new object
     *
     * @param newDeltaParticipants the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeltaParticipants> postAsync(@Nonnull final DeltaParticipants newDeltaParticipants) {
        return sendAsync(HttpMethod.POST, newDeltaParticipants);
    }

    /**
     * Creates a DeltaParticipants with a new object
     *
     * @param newDeltaParticipants the new object to create
     * @return the created DeltaParticipants
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeltaParticipants post(@Nonnull final DeltaParticipants newDeltaParticipants) throws ClientException {
        return send(HttpMethod.POST, newDeltaParticipants);
    }

    /**
     * Creates a DeltaParticipants with a new object
     *
     * @param newDeltaParticipants the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeltaParticipants> putAsync(@Nonnull final DeltaParticipants newDeltaParticipants) {
        return sendAsync(HttpMethod.PUT, newDeltaParticipants);
    }

    /**
     * Creates a DeltaParticipants with a new object
     *
     * @param newDeltaParticipants the object to create/update
     * @return the created DeltaParticipants
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeltaParticipants put(@Nonnull final DeltaParticipants newDeltaParticipants) throws ClientException {
        return send(HttpMethod.PUT, newDeltaParticipants);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeltaParticipantsRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeltaParticipantsRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

