// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ContentSharingSession;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Content Sharing Session Request.
 */
public class ContentSharingSessionRequest extends BaseRequest<ContentSharingSession> {
	
    /**
     * The request for the ContentSharingSession
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ContentSharingSessionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ContentSharingSession.class);
    }

    /**
     * Gets the ContentSharingSession from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContentSharingSession> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ContentSharingSession from the service
     *
     * @return the ContentSharingSession from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ContentSharingSession get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContentSharingSession> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ContentSharingSession delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ContentSharingSession with a source
     *
     * @param sourceContentSharingSession the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContentSharingSession> patchAsync(@Nonnull final ContentSharingSession sourceContentSharingSession) {
        return sendAsync(HttpMethod.PATCH, sourceContentSharingSession);
    }

    /**
     * Patches this ContentSharingSession with a source
     *
     * @param sourceContentSharingSession the source object with updates
     * @return the updated ContentSharingSession
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ContentSharingSession patch(@Nonnull final ContentSharingSession sourceContentSharingSession) throws ClientException {
        return send(HttpMethod.PATCH, sourceContentSharingSession);
    }

    /**
     * Creates a ContentSharingSession with a new object
     *
     * @param newContentSharingSession the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContentSharingSession> postAsync(@Nonnull final ContentSharingSession newContentSharingSession) {
        return sendAsync(HttpMethod.POST, newContentSharingSession);
    }

    /**
     * Creates a ContentSharingSession with a new object
     *
     * @param newContentSharingSession the new object to create
     * @return the created ContentSharingSession
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ContentSharingSession post(@Nonnull final ContentSharingSession newContentSharingSession) throws ClientException {
        return send(HttpMethod.POST, newContentSharingSession);
    }

    /**
     * Creates a ContentSharingSession with a new object
     *
     * @param newContentSharingSession the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContentSharingSession> putAsync(@Nonnull final ContentSharingSession newContentSharingSession) {
        return sendAsync(HttpMethod.PUT, newContentSharingSession);
    }

    /**
     * Creates a ContentSharingSession with a new object
     *
     * @param newContentSharingSession the object to create/update
     * @return the created ContentSharingSession
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ContentSharingSession put(@Nonnull final ContentSharingSession newContentSharingSession) throws ClientException {
        return send(HttpMethod.PUT, newContentSharingSession);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ContentSharingSessionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ContentSharingSessionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

