// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Virtual Event Registration Question Answer.
 */
public class VirtualEventRegistrationQuestionAnswer implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Boolean Value.
     * Boolean answer of the virtual event registration question. Only appears when answerInputType is boolean.
     */
    @SerializedName(value = "booleanValue", alternate = {"BooleanValue"})
    @Expose
	@Nullable
    public Boolean booleanValue;

    /**
     * The Display Name.
     * Display name of the registration question.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Multi Choice Values.
     * Collection of text answer of the virtual event registration question. Only appears when answerInputType is multiChoice.
     */
    @SerializedName(value = "multiChoiceValues", alternate = {"MultiChoiceValues"})
    @Expose
	@Nullable
    public java.util.List<String> multiChoiceValues;

    /**
     * The Question Id.
     * id of the virtual event registration question.
     */
    @SerializedName(value = "questionId", alternate = {"QuestionId"})
    @Expose
	@Nullable
    public String questionId;

    /**
     * The Value.
     * Text answer of the virtual event registration question. Appears when answerInputType is text, multilineText or singleChoice.
     */
    @SerializedName(value = "value", alternate = {"Value"})
    @Expose
	@Nullable
    public String value;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
