// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.SynchronizationJobApplicationParameters;
import com.microsoft.graph.models.StringKeyStringValuePair;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Synchronization Job Provision On Demand Parameter Set.
 */
public class SynchronizationJobProvisionOnDemandParameterSet {
    /**
     * The parameters.
     * 
     */
    @SerializedName(value = "parameters", alternate = {"Parameters"})
    @Expose
	@Nullable
    public java.util.List<SynchronizationJobApplicationParameters> parameters;


    /**
     * Instiaciates a new SynchronizationJobProvisionOnDemandParameterSet
     */
    public SynchronizationJobProvisionOnDemandParameterSet() {}
    /**
     * Instiaciates a new SynchronizationJobProvisionOnDemandParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected SynchronizationJobProvisionOnDemandParameterSet(@Nonnull final SynchronizationJobProvisionOnDemandParameterSetBuilder builder) {
        this.parameters = builder.parameters;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static SynchronizationJobProvisionOnDemandParameterSetBuilder newBuilder() {
        return new SynchronizationJobProvisionOnDemandParameterSetBuilder();
    }
    /**
     * Fluent builder for the SynchronizationJobProvisionOnDemandParameterSet
     */
    public static final class SynchronizationJobProvisionOnDemandParameterSetBuilder {
        /**
         * The parameters parameter value
         */
        @Nullable
        protected java.util.List<SynchronizationJobApplicationParameters> parameters;
        /**
         * Sets the Parameters
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public SynchronizationJobProvisionOnDemandParameterSetBuilder withParameters(@Nullable final java.util.List<SynchronizationJobApplicationParameters> val) {
            this.parameters = val;
            return this;
        }
        /**
         * Instanciates a new SynchronizationJobProvisionOnDemandParameterSetBuilder
         */
        @Nullable
        protected SynchronizationJobProvisionOnDemandParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public SynchronizationJobProvisionOnDemandParameterSet build() {
            return new SynchronizationJobProvisionOnDemandParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.parameters != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("parameters", parameters));
        }
        return result;
    }
}
