// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.BroadcastMeetingSettings;
import com.microsoft.graph.models.MeetingParticipants;
import com.microsoft.graph.models.OnlineMeetingBase;
import com.microsoft.graph.requests.CallRecordingCollectionPage;
import com.microsoft.graph.requests.CallTranscriptCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Online Meeting.
 */
public class OnlineMeeting extends OnlineMeetingBase implements IJsonBackedObject {


    /**
     * The Broadcast Settings.
     * 
     */
    @SerializedName(value = "broadcastSettings", alternate = {"BroadcastSettings"})
    @Expose
	@Nullable
    public BroadcastMeetingSettings broadcastSettings;

    /**
     * The Creation Date Time.
     * The meeting creation time in UTC. Read-only.
     */
    @SerializedName(value = "creationDateTime", alternate = {"CreationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime creationDateTime;

    /**
     * The End Date Time.
     * The meeting end time in UTC.
     */
    @SerializedName(value = "endDateTime", alternate = {"EndDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime endDateTime;

    /**
     * The External Id.
     * 
     */
    @SerializedName(value = "externalId", alternate = {"ExternalId"})
    @Expose
	@Nullable
    public String externalId;

    /**
     * The Is Broadcast.
     * 
     */
    @SerializedName(value = "isBroadcast", alternate = {"IsBroadcast"})
    @Expose
	@Nullable
    public Boolean isBroadcast;

    /**
     * The Participants.
     * The participants associated with the online meeting, including the organizer and the attendees.
     */
    @SerializedName(value = "participants", alternate = {"Participants"})
    @Expose
	@Nullable
    public MeetingParticipants participants;

    /**
     * The Start Date Time.
     * The meeting start time in UTC.
     */
    @SerializedName(value = "startDateTime", alternate = {"StartDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime startDateTime;

    /**
     * The Recordings.
     * The recordings of an online meeting. Read-only.
     */
    @SerializedName(value = "recordings", alternate = {"Recordings"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.CallRecordingCollectionPage recordings;

    /**
     * The Transcripts.
     * The transcripts of an online meeting. Read-only.
     */
    @SerializedName(value = "transcripts", alternate = {"Transcripts"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.CallTranscriptCollectionPage transcripts;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("recordings")) {
            recordings = serializer.deserializeObject(json.get("recordings"), com.microsoft.graph.requests.CallRecordingCollectionPage.class);
        }

        if (json.has("transcripts")) {
            transcripts = serializer.deserializeObject(json.get("transcripts"), com.microsoft.graph.requests.CallTranscriptCollectionPage.class);
        }
    }
}
