// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.OnPremisesDirectorySynchronizationConfiguration;
import com.microsoft.graph.models.OnPremisesDirectorySynchronizationFeature;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the On Premises Directory Synchronization.
 */
public class OnPremisesDirectorySynchronization extends Entity implements IJsonBackedObject {


    /**
     * The Configuration.
     * Consists of configurations that can be fine-tuned and impact the on-premises directory synchronization process for a tenant.
     */
    @SerializedName(value = "configuration", alternate = {"Configuration"})
    @Expose
	@Nullable
    public OnPremisesDirectorySynchronizationConfiguration configuration;

    /**
     * The Features.
     * Consists of directory synchronization features that can be enabled or disabled.
     */
    @SerializedName(value = "features", alternate = {"Features"})
    @Expose
	@Nullable
    public OnPremisesDirectorySynchronizationFeature features;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
