// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.ItemActivityStat;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Item Analytics.
 */
public class ItemAnalytics extends Entity implements IJsonBackedObject {


    /**
     * The All Time.
     * 
     */
    @SerializedName(value = "allTime", alternate = {"AllTime"})
    @Expose
	@Nullable
    public ItemActivityStat allTime;

    /**
     * The Item Activity Stats.
     * 
     */
    @SerializedName(value = "itemActivityStats", alternate = {"ItemActivityStats"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.ItemActivityStatCollectionPage itemActivityStats;

    /**
     * The Last Seven Days.
     * 
     */
    @SerializedName(value = "lastSevenDays", alternate = {"LastSevenDays"})
    @Expose
	@Nullable
    public ItemActivityStat lastSevenDays;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("itemActivityStats")) {
            itemActivityStats = serializer.deserializeObject(json.get("itemActivityStats"), com.microsoft.graph.requests.ItemActivityStatCollectionPage.class);
        }
    }
}
