// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.TeamworkUserIdentity;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Chat Hide For User Parameter Set.
 */
public class ChatHideForUserParameterSet {
    /**
     * The user.
     * 
     */
    @SerializedName(value = "user", alternate = {"User"})
    @Expose
	@Nullable
    public TeamworkUserIdentity user;


    /**
     * Instiaciates a new ChatHideForUserParameterSet
     */
    public ChatHideForUserParameterSet() {}
    /**
     * Instiaciates a new ChatHideForUserParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ChatHideForUserParameterSet(@Nonnull final ChatHideForUserParameterSetBuilder builder) {
        this.user = builder.user;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ChatHideForUserParameterSetBuilder newBuilder() {
        return new ChatHideForUserParameterSetBuilder();
    }
    /**
     * Fluent builder for the ChatHideForUserParameterSet
     */
    public static final class ChatHideForUserParameterSetBuilder {
        /**
         * The user parameter value
         */
        @Nullable
        protected TeamworkUserIdentity user;
        /**
         * Sets the User
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ChatHideForUserParameterSetBuilder withUser(@Nullable final TeamworkUserIdentity val) {
            this.user = val;
            return this;
        }
        /**
         * Instanciates a new ChatHideForUserParameterSetBuilder
         */
        @Nullable
        protected ChatHideForUserParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ChatHideForUserParameterSet build() {
            return new ChatHideForUserParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.user != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("user", user));
        }
        return result;
    }
}
