// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.VirtualEventWebinar;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Virtual Event Webinar Request.
 */
public class VirtualEventWebinarRequest extends BaseRequest<VirtualEventWebinar> {
	
    /**
     * The request for the VirtualEventWebinar
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public VirtualEventWebinarRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, VirtualEventWebinar.class);
    }

    /**
     * Gets the VirtualEventWebinar from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventWebinar> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the VirtualEventWebinar from the service
     *
     * @return the VirtualEventWebinar from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventWebinar get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventWebinar> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public VirtualEventWebinar delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this VirtualEventWebinar with a source
     *
     * @param sourceVirtualEventWebinar the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventWebinar> patchAsync(@Nonnull final VirtualEventWebinar sourceVirtualEventWebinar) {
        return sendAsync(HttpMethod.PATCH, sourceVirtualEventWebinar);
    }

    /**
     * Patches this VirtualEventWebinar with a source
     *
     * @param sourceVirtualEventWebinar the source object with updates
     * @return the updated VirtualEventWebinar
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventWebinar patch(@Nonnull final VirtualEventWebinar sourceVirtualEventWebinar) throws ClientException {
        return send(HttpMethod.PATCH, sourceVirtualEventWebinar);
    }

    /**
     * Creates a VirtualEventWebinar with a new object
     *
     * @param newVirtualEventWebinar the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventWebinar> postAsync(@Nonnull final VirtualEventWebinar newVirtualEventWebinar) {
        return sendAsync(HttpMethod.POST, newVirtualEventWebinar);
    }

    /**
     * Creates a VirtualEventWebinar with a new object
     *
     * @param newVirtualEventWebinar the new object to create
     * @return the created VirtualEventWebinar
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventWebinar post(@Nonnull final VirtualEventWebinar newVirtualEventWebinar) throws ClientException {
        return send(HttpMethod.POST, newVirtualEventWebinar);
    }

    /**
     * Creates a VirtualEventWebinar with a new object
     *
     * @param newVirtualEventWebinar the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventWebinar> putAsync(@Nonnull final VirtualEventWebinar newVirtualEventWebinar) {
        return sendAsync(HttpMethod.PUT, newVirtualEventWebinar);
    }

    /**
     * Creates a VirtualEventWebinar with a new object
     *
     * @param newVirtualEventWebinar the object to create/update
     * @return the created VirtualEventWebinar
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventWebinar put(@Nonnull final VirtualEventWebinar newVirtualEventWebinar) throws ClientException {
        return send(HttpMethod.PUT, newVirtualEventWebinar);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public VirtualEventWebinarRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public VirtualEventWebinarRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

