// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EligibilityScheduleRequestFilterByCurrentUserOptions;
import com.microsoft.graph.models.PrivilegedAccessGroupEligibilityScheduleRequest;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionRequestBuilder;
import com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionRequest;
import com.microsoft.graph.requests.PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionResponse;
import com.microsoft.graph.models.PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Group Eligibility Schedule Request Filter By Current User Collection Request Builder.
 */
public class PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<PrivilegedAccessGroupEligibilityScheduleRequest, PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionRequestBuilder, PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionResponse, PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionPage, PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionRequest> {

    /**
     * The request builder for this collection of PrivilegedAccessGroupEligibilityScheduleRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionRequestBuilder.class, PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionRequest.class);
    }
    /**
     * The request builder for this collection of PrivilegedAccessGroupEligibilityScheduleRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserParameterSet parameters) {
        super(requestUrl, client, requestOptions, PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionRequestBuilder.class, PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionRequest instance
     */
    @Override
    @Nonnull
    public PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final PrivilegedAccessGroupEligibilityScheduleRequestFilterByCurrentUserCollectionRequest request = super.buildRequest(requestOptions);
        if(functionOptions != null) {    
            for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
                request.addFunctionOption(option);
            }
        }
        return request;
    }
}
