// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.LearningAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Learning Assignment Request.
 */
public class LearningAssignmentRequest extends BaseRequest<LearningAssignment> {
	
    /**
     * The request for the LearningAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LearningAssignmentRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, LearningAssignment.class);
    }

    /**
     * Gets the LearningAssignment from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningAssignment> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the LearningAssignment from the service
     *
     * @return the LearningAssignment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningAssignment get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningAssignment> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public LearningAssignment delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this LearningAssignment with a source
     *
     * @param sourceLearningAssignment the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningAssignment> patchAsync(@Nonnull final LearningAssignment sourceLearningAssignment) {
        return sendAsync(HttpMethod.PATCH, sourceLearningAssignment);
    }

    /**
     * Patches this LearningAssignment with a source
     *
     * @param sourceLearningAssignment the source object with updates
     * @return the updated LearningAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningAssignment patch(@Nonnull final LearningAssignment sourceLearningAssignment) throws ClientException {
        return send(HttpMethod.PATCH, sourceLearningAssignment);
    }

    /**
     * Creates a LearningAssignment with a new object
     *
     * @param newLearningAssignment the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningAssignment> postAsync(@Nonnull final LearningAssignment newLearningAssignment) {
        return sendAsync(HttpMethod.POST, newLearningAssignment);
    }

    /**
     * Creates a LearningAssignment with a new object
     *
     * @param newLearningAssignment the new object to create
     * @return the created LearningAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningAssignment post(@Nonnull final LearningAssignment newLearningAssignment) throws ClientException {
        return send(HttpMethod.POST, newLearningAssignment);
    }

    /**
     * Creates a LearningAssignment with a new object
     *
     * @param newLearningAssignment the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningAssignment> putAsync(@Nonnull final LearningAssignment newLearningAssignment) {
        return sendAsync(HttpMethod.PUT, newLearningAssignment);
    }

    /**
     * Creates a LearningAssignment with a new object
     *
     * @param newLearningAssignment the object to create/update
     * @return the created LearningAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningAssignment put(@Nonnull final LearningAssignment newLearningAssignment) throws ClientException {
        return send(HttpMethod.PUT, newLearningAssignment);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public LearningAssignmentRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public LearningAssignmentRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

