// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.MeetingAudience;
import com.microsoft.graph.models.CommunicationsUserIdentity;
import com.microsoft.graph.models.VirtualEvent;
import com.microsoft.graph.requests.VirtualEventRegistrationCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Virtual Event Webinar.
 */
public class VirtualEventWebinar extends VirtualEvent implements IJsonBackedObject {


    /**
     * The Audience.
     * 
     */
    @SerializedName(value = "audience", alternate = {"Audience"})
    @Expose
	@Nullable
    public MeetingAudience audience;

    /**
     * The Co Organizers.
     * 
     */
    @SerializedName(value = "coOrganizers", alternate = {"CoOrganizers"})
    @Expose
	@Nullable
    public java.util.List<CommunicationsUserIdentity> coOrganizers;

    /**
     * The Registrations.
     * 
     */
    @SerializedName(value = "registrations", alternate = {"Registrations"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.VirtualEventRegistrationCollectionPage registrations;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("registrations")) {
            registrations = serializer.deserializeObject(json.get("registrations"), com.microsoft.graph.requests.VirtualEventRegistrationCollectionPage.class);
        }
    }
}
