// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.CoachmarkLocation;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Payload Coachmark.
 */
public class PayloadCoachmark implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Coachmark Location.
     * The coachmark location.
     */
    @SerializedName(value = "coachmarkLocation", alternate = {"CoachmarkLocation"})
    @Expose
	@Nullable
    public CoachmarkLocation coachmarkLocation;

    /**
     * The Description.
     * The description about the coachmark.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Indicator.
     * The coachmark indicator.
     */
    @SerializedName(value = "indicator", alternate = {"Indicator"})
    @Expose
	@Nullable
    public String indicator;

    /**
     * The Is Valid.
     * Indicates whether the coachmark is valid or not.
     */
    @SerializedName(value = "isValid", alternate = {"IsValid"})
    @Expose
	@Nullable
    public Boolean isValid;

    /**
     * The Language.
     * The coachmark language.
     */
    @SerializedName(value = "language", alternate = {"Language"})
    @Expose
	@Nullable
    public String language;

    /**
     * The Order.
     * The coachmark order.
     */
    @SerializedName(value = "order", alternate = {"Order"})
    @Expose
	@Nullable
    public String order;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
