// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.OnlineMeetingPresenters;
import com.microsoft.graph.models.MeetingChatMode;
import com.microsoft.graph.models.AudioConferencing;
import com.microsoft.graph.models.ChatInfo;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.JoinMeetingIdSettings;
import com.microsoft.graph.models.LobbyBypassSettings;
import com.microsoft.graph.models.MeetingChatHistoryDefaultMode;
import com.microsoft.graph.models.WatermarkProtectionValues;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.MeetingAttendanceReportCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Online Meeting Base.
 */
public class OnlineMeetingBase extends Entity implements IJsonBackedObject {


    /**
     * The Allow Attendee To Enable Camera.
     * 
     */
    @SerializedName(value = "allowAttendeeToEnableCamera", alternate = {"AllowAttendeeToEnableCamera"})
    @Expose
	@Nullable
    public Boolean allowAttendeeToEnableCamera;

    /**
     * The Allow Attendee To Enable Mic.
     * 
     */
    @SerializedName(value = "allowAttendeeToEnableMic", alternate = {"AllowAttendeeToEnableMic"})
    @Expose
	@Nullable
    public Boolean allowAttendeeToEnableMic;

    /**
     * The Allowed Presenters.
     * 
     */
    @SerializedName(value = "allowedPresenters", alternate = {"AllowedPresenters"})
    @Expose
	@Nullable
    public OnlineMeetingPresenters allowedPresenters;

    /**
     * The Allow Meeting Chat.
     * 
     */
    @SerializedName(value = "allowMeetingChat", alternate = {"AllowMeetingChat"})
    @Expose
	@Nullable
    public MeetingChatMode allowMeetingChat;

    /**
     * The Allow Participants To Change Name.
     * 
     */
    @SerializedName(value = "allowParticipantsToChangeName", alternate = {"AllowParticipantsToChangeName"})
    @Expose
	@Nullable
    public Boolean allowParticipantsToChangeName;

    /**
     * The Allow Teamwork Reactions.
     * 
     */
    @SerializedName(value = "allowTeamworkReactions", alternate = {"AllowTeamworkReactions"})
    @Expose
	@Nullable
    public Boolean allowTeamworkReactions;

    /**
     * The Audio Conferencing.
     * 
     */
    @SerializedName(value = "audioConferencing", alternate = {"AudioConferencing"})
    @Expose
	@Nullable
    public AudioConferencing audioConferencing;

    /**
     * The Chat Info.
     * 
     */
    @SerializedName(value = "chatInfo", alternate = {"ChatInfo"})
    @Expose
	@Nullable
    public ChatInfo chatInfo;

    /**
     * The Is Entry Exit Announced.
     * 
     */
    @SerializedName(value = "isEntryExitAnnounced", alternate = {"IsEntryExitAnnounced"})
    @Expose
	@Nullable
    public Boolean isEntryExitAnnounced;

    /**
     * The Join Information.
     * 
     */
    @SerializedName(value = "joinInformation", alternate = {"JoinInformation"})
    @Expose
	@Nullable
    public ItemBody joinInformation;

    /**
     * The Join Meeting Id Settings.
     * 
     */
    @SerializedName(value = "joinMeetingIdSettings", alternate = {"JoinMeetingIdSettings"})
    @Expose
	@Nullable
    public JoinMeetingIdSettings joinMeetingIdSettings;

    /**
     * The Join Web Url.
     * 
     */
    @SerializedName(value = "joinWebUrl", alternate = {"JoinWebUrl"})
    @Expose
	@Nullable
    public String joinWebUrl;

    /**
     * The Lobby Bypass Settings.
     * 
     */
    @SerializedName(value = "lobbyBypassSettings", alternate = {"LobbyBypassSettings"})
    @Expose
	@Nullable
    public LobbyBypassSettings lobbyBypassSettings;

    /**
     * The Record Automatically.
     * 
     */
    @SerializedName(value = "recordAutomatically", alternate = {"RecordAutomatically"})
    @Expose
	@Nullable
    public Boolean recordAutomatically;

    /**
     * The Share Meeting Chat History Default.
     * 
     */
    @SerializedName(value = "shareMeetingChatHistoryDefault", alternate = {"ShareMeetingChatHistoryDefault"})
    @Expose
	@Nullable
    public MeetingChatHistoryDefaultMode shareMeetingChatHistoryDefault;

    /**
     * The Subject.
     * 
     */
    @SerializedName(value = "subject", alternate = {"Subject"})
    @Expose
	@Nullable
    public String subject;

    /**
     * The Video Teleconference Id.
     * 
     */
    @SerializedName(value = "videoTeleconferenceId", alternate = {"VideoTeleconferenceId"})
    @Expose
	@Nullable
    public String videoTeleconferenceId;

    /**
     * The Watermark Protection.
     * 
     */
    @SerializedName(value = "watermarkProtection", alternate = {"WatermarkProtection"})
    @Expose
	@Nullable
    public WatermarkProtectionValues watermarkProtection;

    /**
     * The Attendance Reports.
     * 
     */
    @SerializedName(value = "attendanceReports", alternate = {"AttendanceReports"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.MeetingAttendanceReportCollectionPage attendanceReports;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("attendanceReports")) {
            attendanceReports = serializer.deserializeObject(json.get("attendanceReports"), com.microsoft.graph.requests.MeetingAttendanceReportCollectionPage.class);
        }
    }
}
