// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Recording.
 */
public class CallRecording extends Entity implements IJsonBackedObject {


    /**
     * The Created Date Time.
     * Date and time at which the recording was created. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Read-only.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Meeting Id.
     * The unique identifier of the onlineMeeting related to this recording. Read-only.
     */
    @SerializedName(value = "meetingId", alternate = {"MeetingId"})
    @Expose
	@Nullable
    public String meetingId;

    /**
     * The Meeting Organizer.
     * The identity information of the organizer of the onlineMeeting related to this recording. Read-only.
     */
    @SerializedName(value = "meetingOrganizer", alternate = {"MeetingOrganizer"})
    @Expose
	@Nullable
    public IdentitySet meetingOrganizer;

    /**
     * The Recording Content Url.
     * The URL that can be used to access the content of the recording. Read-only.
     */
    @SerializedName(value = "recordingContentUrl", alternate = {"RecordingContentUrl"})
    @Expose
	@Nullable
    public String recordingContentUrl;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
