// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.TaskProcessingResult;
import com.microsoft.graph.identitygovernance.models.CustomTaskExtensionCallbackData;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Task Processing Result Request.
 */
public class TaskProcessingResultRequest extends BaseRequest<TaskProcessingResult> {
	
    /**
     * The request for the TaskProcessingResult
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TaskProcessingResultRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TaskProcessingResult.class);
    }

    /**
     * Gets the TaskProcessingResult from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TaskProcessingResult> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TaskProcessingResult from the service
     *
     * @return the TaskProcessingResult from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TaskProcessingResult get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TaskProcessingResult> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TaskProcessingResult delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TaskProcessingResult with a source
     *
     * @param sourceTaskProcessingResult the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TaskProcessingResult> patchAsync(@Nonnull final TaskProcessingResult sourceTaskProcessingResult) {
        return sendAsync(HttpMethod.PATCH, sourceTaskProcessingResult);
    }

    /**
     * Patches this TaskProcessingResult with a source
     *
     * @param sourceTaskProcessingResult the source object with updates
     * @return the updated TaskProcessingResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TaskProcessingResult patch(@Nonnull final TaskProcessingResult sourceTaskProcessingResult) throws ClientException {
        return send(HttpMethod.PATCH, sourceTaskProcessingResult);
    }

    /**
     * Creates a TaskProcessingResult with a new object
     *
     * @param newTaskProcessingResult the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TaskProcessingResult> postAsync(@Nonnull final TaskProcessingResult newTaskProcessingResult) {
        return sendAsync(HttpMethod.POST, newTaskProcessingResult);
    }

    /**
     * Creates a TaskProcessingResult with a new object
     *
     * @param newTaskProcessingResult the new object to create
     * @return the created TaskProcessingResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TaskProcessingResult post(@Nonnull final TaskProcessingResult newTaskProcessingResult) throws ClientException {
        return send(HttpMethod.POST, newTaskProcessingResult);
    }

    /**
     * Creates a TaskProcessingResult with a new object
     *
     * @param newTaskProcessingResult the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TaskProcessingResult> putAsync(@Nonnull final TaskProcessingResult newTaskProcessingResult) {
        return sendAsync(HttpMethod.PUT, newTaskProcessingResult);
    }

    /**
     * Creates a TaskProcessingResult with a new object
     *
     * @param newTaskProcessingResult the object to create/update
     * @return the created TaskProcessingResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TaskProcessingResult put(@Nonnull final TaskProcessingResult newTaskProcessingResult) throws ClientException {
        return send(HttpMethod.PUT, newTaskProcessingResult);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TaskProcessingResultRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TaskProcessingResultRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

