// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.SynchronizationSchemaParseExpressionRequest;
import com.microsoft.graph.models.SynchronizationSchema;
import com.microsoft.graph.models.ExpressionInputObject;
import com.microsoft.graph.models.AttributeDefinition;
import com.microsoft.graph.models.ParseExpressionResponse;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.SynchronizationSchemaParseExpressionParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Synchronization Schema Parse Expression Request Builder.
 */
public class SynchronizationSchemaParseExpressionRequestBuilder extends BaseActionRequestBuilder<ParseExpressionResponse> {

    /**
     * The request builder for this SynchronizationSchemaParseExpression
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SynchronizationSchemaParseExpressionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private SynchronizationSchemaParseExpressionParameterSet body;
    /**
     * The request builder for this SynchronizationSchemaParseExpression
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public SynchronizationSchemaParseExpressionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final SynchronizationSchemaParseExpressionParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the SynchronizationSchemaParseExpressionRequest
     *
     * @param requestOptions the options for the request
     * @return the SynchronizationSchemaParseExpressionRequest instance
     */
    @Nonnull
    public SynchronizationSchemaParseExpressionRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the SynchronizationSchemaParseExpressionRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the SynchronizationSchemaParseExpressionRequest instance
     */
    @Nonnull
    public SynchronizationSchemaParseExpressionRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final SynchronizationSchemaParseExpressionRequest request = new SynchronizationSchemaParseExpressionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
