// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrivilegedAccessGroup;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Group Request.
 */
public class PrivilegedAccessGroupRequest extends BaseRequest<PrivilegedAccessGroup> {
	
    /**
     * The request for the PrivilegedAccessGroup
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrivilegedAccessGroupRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrivilegedAccessGroup.class);
    }

    /**
     * Gets the PrivilegedAccessGroup from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroup> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrivilegedAccessGroup from the service
     *
     * @return the PrivilegedAccessGroup from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroup get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroup> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrivilegedAccessGroup delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrivilegedAccessGroup with a source
     *
     * @param sourcePrivilegedAccessGroup the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroup> patchAsync(@Nonnull final PrivilegedAccessGroup sourcePrivilegedAccessGroup) {
        return sendAsync(HttpMethod.PATCH, sourcePrivilegedAccessGroup);
    }

    /**
     * Patches this PrivilegedAccessGroup with a source
     *
     * @param sourcePrivilegedAccessGroup the source object with updates
     * @return the updated PrivilegedAccessGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroup patch(@Nonnull final PrivilegedAccessGroup sourcePrivilegedAccessGroup) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrivilegedAccessGroup);
    }

    /**
     * Creates a PrivilegedAccessGroup with a new object
     *
     * @param newPrivilegedAccessGroup the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroup> postAsync(@Nonnull final PrivilegedAccessGroup newPrivilegedAccessGroup) {
        return sendAsync(HttpMethod.POST, newPrivilegedAccessGroup);
    }

    /**
     * Creates a PrivilegedAccessGroup with a new object
     *
     * @param newPrivilegedAccessGroup the new object to create
     * @return the created PrivilegedAccessGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroup post(@Nonnull final PrivilegedAccessGroup newPrivilegedAccessGroup) throws ClientException {
        return send(HttpMethod.POST, newPrivilegedAccessGroup);
    }

    /**
     * Creates a PrivilegedAccessGroup with a new object
     *
     * @param newPrivilegedAccessGroup the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessGroup> putAsync(@Nonnull final PrivilegedAccessGroup newPrivilegedAccessGroup) {
        return sendAsync(HttpMethod.PUT, newPrivilegedAccessGroup);
    }

    /**
     * Creates a PrivilegedAccessGroup with a new object
     *
     * @param newPrivilegedAccessGroup the object to create/update
     * @return the created PrivilegedAccessGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessGroup put(@Nonnull final PrivilegedAccessGroup newPrivilegedAccessGroup) throws ClientException {
        return send(HttpMethod.PUT, newPrivilegedAccessGroup);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrivilegedAccessGroupRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrivilegedAccessGroupRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

