// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EmailAuthenticationMethod;
import com.microsoft.graph.models.PasswordResetResponse;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Email Authentication Method Request.
 */
public class EmailAuthenticationMethodRequest extends BaseRequest<EmailAuthenticationMethod> {
	
    /**
     * The request for the EmailAuthenticationMethod
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EmailAuthenticationMethodRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EmailAuthenticationMethod.class);
    }

    /**
     * Gets the EmailAuthenticationMethod from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmailAuthenticationMethod> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EmailAuthenticationMethod from the service
     *
     * @return the EmailAuthenticationMethod from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmailAuthenticationMethod get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmailAuthenticationMethod> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EmailAuthenticationMethod delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EmailAuthenticationMethod with a source
     *
     * @param sourceEmailAuthenticationMethod the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmailAuthenticationMethod> patchAsync(@Nonnull final EmailAuthenticationMethod sourceEmailAuthenticationMethod) {
        return sendAsync(HttpMethod.PATCH, sourceEmailAuthenticationMethod);
    }

    /**
     * Patches this EmailAuthenticationMethod with a source
     *
     * @param sourceEmailAuthenticationMethod the source object with updates
     * @return the updated EmailAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmailAuthenticationMethod patch(@Nonnull final EmailAuthenticationMethod sourceEmailAuthenticationMethod) throws ClientException {
        return send(HttpMethod.PATCH, sourceEmailAuthenticationMethod);
    }

    /**
     * Creates a EmailAuthenticationMethod with a new object
     *
     * @param newEmailAuthenticationMethod the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmailAuthenticationMethod> postAsync(@Nonnull final EmailAuthenticationMethod newEmailAuthenticationMethod) {
        return sendAsync(HttpMethod.POST, newEmailAuthenticationMethod);
    }

    /**
     * Creates a EmailAuthenticationMethod with a new object
     *
     * @param newEmailAuthenticationMethod the new object to create
     * @return the created EmailAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmailAuthenticationMethod post(@Nonnull final EmailAuthenticationMethod newEmailAuthenticationMethod) throws ClientException {
        return send(HttpMethod.POST, newEmailAuthenticationMethod);
    }

    /**
     * Creates a EmailAuthenticationMethod with a new object
     *
     * @param newEmailAuthenticationMethod the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmailAuthenticationMethod> putAsync(@Nonnull final EmailAuthenticationMethod newEmailAuthenticationMethod) {
        return sendAsync(HttpMethod.PUT, newEmailAuthenticationMethod);
    }

    /**
     * Creates a EmailAuthenticationMethod with a new object
     *
     * @param newEmailAuthenticationMethod the object to create/update
     * @return the created EmailAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmailAuthenticationMethod put(@Nonnull final EmailAuthenticationMethod newEmailAuthenticationMethod) throws ClientException {
        return send(HttpMethod.PUT, newEmailAuthenticationMethod);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EmailAuthenticationMethodRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EmailAuthenticationMethodRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

