// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AppLogCollectionRequest;
import com.microsoft.graph.models.AppLogCollectionDownloadDetails;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the App Log Collection Request Request.
 */
public class AppLogCollectionRequestRequest extends BaseRequest<AppLogCollectionRequest> {
	
    /**
     * The request for the AppLogCollectionRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AppLogCollectionRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AppLogCollectionRequest.class);
    }

    /**
     * Gets the AppLogCollectionRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppLogCollectionRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AppLogCollectionRequest from the service
     *
     * @return the AppLogCollectionRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppLogCollectionRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppLogCollectionRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AppLogCollectionRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AppLogCollectionRequest with a source
     *
     * @param sourceAppLogCollectionRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppLogCollectionRequest> patchAsync(@Nonnull final AppLogCollectionRequest sourceAppLogCollectionRequest) {
        return sendAsync(HttpMethod.PATCH, sourceAppLogCollectionRequest);
    }

    /**
     * Patches this AppLogCollectionRequest with a source
     *
     * @param sourceAppLogCollectionRequest the source object with updates
     * @return the updated AppLogCollectionRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppLogCollectionRequest patch(@Nonnull final AppLogCollectionRequest sourceAppLogCollectionRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceAppLogCollectionRequest);
    }

    /**
     * Creates a AppLogCollectionRequest with a new object
     *
     * @param newAppLogCollectionRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppLogCollectionRequest> postAsync(@Nonnull final AppLogCollectionRequest newAppLogCollectionRequest) {
        return sendAsync(HttpMethod.POST, newAppLogCollectionRequest);
    }

    /**
     * Creates a AppLogCollectionRequest with a new object
     *
     * @param newAppLogCollectionRequest the new object to create
     * @return the created AppLogCollectionRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppLogCollectionRequest post(@Nonnull final AppLogCollectionRequest newAppLogCollectionRequest) throws ClientException {
        return send(HttpMethod.POST, newAppLogCollectionRequest);
    }

    /**
     * Creates a AppLogCollectionRequest with a new object
     *
     * @param newAppLogCollectionRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppLogCollectionRequest> putAsync(@Nonnull final AppLogCollectionRequest newAppLogCollectionRequest) {
        return sendAsync(HttpMethod.PUT, newAppLogCollectionRequest);
    }

    /**
     * Creates a AppLogCollectionRequest with a new object
     *
     * @param newAppLogCollectionRequest the object to create/update
     * @return the created AppLogCollectionRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AppLogCollectionRequest put(@Nonnull final AppLogCollectionRequest newAppLogCollectionRequest) throws ClientException {
        return send(HttpMethod.PUT, newAppLogCollectionRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AppLogCollectionRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AppLogCollectionRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

