// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Sum If Parameter Set.
 */
public class WorkbookFunctionsSumIfParameterSet {
    /**
     * The range.
     * 
     */
    @SerializedName(value = "range", alternate = {"Range"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement range;

    /**
     * The criteria.
     * 
     */
    @SerializedName(value = "criteria", alternate = {"Criteria"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement criteria;

    /**
     * The sum Range.
     * 
     */
    @SerializedName(value = "sumRange", alternate = {"SumRange"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement sumRange;


    /**
     * Instiaciates a new WorkbookFunctionsSumIfParameterSet
     */
    public WorkbookFunctionsSumIfParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsSumIfParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsSumIfParameterSet(@Nonnull final WorkbookFunctionsSumIfParameterSetBuilder builder) {
        this.range = builder.range;
        this.criteria = builder.criteria;
        this.sumRange = builder.sumRange;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsSumIfParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsSumIfParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsSumIfParameterSet
     */
    public static final class WorkbookFunctionsSumIfParameterSetBuilder {
        /**
         * The range parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement range;
        /**
         * Sets the Range
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsSumIfParameterSetBuilder withRange(@Nullable final com.google.gson.JsonElement val) {
            this.range = val;
            return this;
        }
        /**
         * The criteria parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement criteria;
        /**
         * Sets the Criteria
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsSumIfParameterSetBuilder withCriteria(@Nullable final com.google.gson.JsonElement val) {
            this.criteria = val;
            return this;
        }
        /**
         * The sumRange parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement sumRange;
        /**
         * Sets the SumRange
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsSumIfParameterSetBuilder withSumRange(@Nullable final com.google.gson.JsonElement val) {
            this.sumRange = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsSumIfParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsSumIfParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsSumIfParameterSet build() {
            return new WorkbookFunctionsSumIfParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.range != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("range", range));
        }
        if(this.criteria != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("criteria", criteria));
        }
        if(this.sumRange != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("sumRange", sumRange));
        }
        return result;
    }
}
