// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.ProvisioningStatusErrorCategory;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Provisioning Error Info.
 */
public class ProvisioningErrorInfo implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Additional Details.
     * Additional details if there's error.
     */
    @SerializedName(value = "additionalDetails", alternate = {"AdditionalDetails"})
    @Expose
	@Nullable
    public String additionalDetails;

    /**
     * The Error Category.
     * Categorizes the error code. Possible values are failure, nonServiceFailure, success, unknownFutureValue
     */
    @SerializedName(value = "errorCategory", alternate = {"ErrorCategory"})
    @Expose
	@Nullable
    public ProvisioningStatusErrorCategory errorCategory;

    /**
     * The Error Code.
     * Unique error code if any occurred. Learn more
     */
    @SerializedName(value = "errorCode", alternate = {"ErrorCode"})
    @Expose
	@Nullable
    public String errorCode;

    /**
     * The Reason.
     * Summarizes the status and describes why the status happened.
     */
    @SerializedName(value = "reason", alternate = {"Reason"})
    @Expose
	@Nullable
    public String reason;

    /**
     * The Recommended Action.
     * Provides the resolution for the corresponding error.
     */
    @SerializedName(value = "recommendedAction", alternate = {"RecommendedAction"})
    @Expose
	@Nullable
    public String recommendedAction;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
