// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.EndUserNotificationPreference;
import com.microsoft.graph.models.PositiveReinforcementNotification;
import com.microsoft.graph.models.EndUserNotificationSettingType;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the End User Notification Setting.
 */
public class EndUserNotificationSetting implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Notification Preference.
     * Notification preference. Possible values are: unknown, microsoft, custom, unknownFutureValue.
     */
    @SerializedName(value = "notificationPreference", alternate = {"NotificationPreference"})
    @Expose
	@Nullable
    public EndUserNotificationPreference notificationPreference;

    /**
     * The Positive Reinforcement.
     * Positive reinforcement detail.
     */
    @SerializedName(value = "positiveReinforcement", alternate = {"PositiveReinforcement"})
    @Expose
	@Nullable
    public PositiveReinforcementNotification positiveReinforcement;

    /**
     * The Setting Type.
     * End user notification type. Possible values are: unknown, noTraining, trainingSelected, noNotification, unknownFutureValue.
     */
    @SerializedName(value = "settingType", alternate = {"SettingType"})
    @Expose
	@Nullable
    public EndUserNotificationSettingType settingType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
