// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.EventMessageDetail;
import com.microsoft.graph.models.ChatMessageFromIdentitySet;
import com.microsoft.graph.models.ChatMessageType;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Chat Message Info.
 */
public class ChatMessageInfo extends Entity implements IJsonBackedObject {


    /**
     * The Body.
     * Body of the chatMessage. This will still contain markers for @mentions and attachments even though the object doesn't return @mentions and attachments.
     */
    @SerializedName(value = "body", alternate = {"Body"})
    @Expose
	@Nullable
    public ItemBody body;

    /**
     * The Created Date Time.
     * Date time object representing the time at which message was created.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Event Detail.
     * Read-only.  If present, represents details of an event that happened in a chat, a channel, or a team, for example, members were added, and so on. For event messages, the messageType property is set to systemEventMessage.
     */
    @SerializedName(value = "eventDetail", alternate = {"EventDetail"})
    @Expose
	@Nullable
    public EventMessageDetail eventDetail;

    /**
     * The From.
     * Information about the sender of the message.
     */
    @SerializedName(value = "from", alternate = {"From"})
    @Expose
	@Nullable
    public ChatMessageFromIdentitySet from;

    /**
     * The Is Deleted.
     * If set to true, the original message has been deleted.
     */
    @SerializedName(value = "isDeleted", alternate = {"IsDeleted"})
    @Expose
	@Nullable
    public Boolean isDeleted;

    /**
     * The Message Type.
     * The type of chat message. The possible values are: message, unknownFutureValue, systemEventMessage.
     */
    @SerializedName(value = "messageType", alternate = {"MessageType"})
    @Expose
	@Nullable
    public ChatMessageType messageType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
