// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.UserProcessingResult;
import com.microsoft.graph.identitygovernance.models.UserSummary;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Processing Result Request.
 */
public class UserProcessingResultRequest extends BaseRequest<UserProcessingResult> {
	
    /**
     * The request for the UserProcessingResult
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserProcessingResultRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserProcessingResult.class);
    }

    /**
     * Gets the UserProcessingResult from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserProcessingResult> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserProcessingResult from the service
     *
     * @return the UserProcessingResult from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserProcessingResult get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserProcessingResult> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserProcessingResult delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserProcessingResult with a source
     *
     * @param sourceUserProcessingResult the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserProcessingResult> patchAsync(@Nonnull final UserProcessingResult sourceUserProcessingResult) {
        return sendAsync(HttpMethod.PATCH, sourceUserProcessingResult);
    }

    /**
     * Patches this UserProcessingResult with a source
     *
     * @param sourceUserProcessingResult the source object with updates
     * @return the updated UserProcessingResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserProcessingResult patch(@Nonnull final UserProcessingResult sourceUserProcessingResult) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserProcessingResult);
    }

    /**
     * Creates a UserProcessingResult with a new object
     *
     * @param newUserProcessingResult the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserProcessingResult> postAsync(@Nonnull final UserProcessingResult newUserProcessingResult) {
        return sendAsync(HttpMethod.POST, newUserProcessingResult);
    }

    /**
     * Creates a UserProcessingResult with a new object
     *
     * @param newUserProcessingResult the new object to create
     * @return the created UserProcessingResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserProcessingResult post(@Nonnull final UserProcessingResult newUserProcessingResult) throws ClientException {
        return send(HttpMethod.POST, newUserProcessingResult);
    }

    /**
     * Creates a UserProcessingResult with a new object
     *
     * @param newUserProcessingResult the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserProcessingResult> putAsync(@Nonnull final UserProcessingResult newUserProcessingResult) {
        return sendAsync(HttpMethod.PUT, newUserProcessingResult);
    }

    /**
     * Creates a UserProcessingResult with a new object
     *
     * @param newUserProcessingResult the object to create/update
     * @return the created UserProcessingResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserProcessingResult put(@Nonnull final UserProcessingResult newUserProcessingResult) throws ClientException {
        return send(HttpMethod.PUT, newUserProcessingResult);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserProcessingResultRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserProcessingResultRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

