// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.identitygovernance.models.LifecycleWorkflowProcessingStatus;
import com.microsoft.graph.identitygovernance.models.Task;
import com.microsoft.graph.identitygovernance.models.TaskDefinition;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.identitygovernance.requests.TaskProcessingResultCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Task Report.
 */
public class TaskReport extends Entity implements IJsonBackedObject {


    /**
     * The Completed Date Time.
     * The date time that the associated run completed. Value is null if the run has not completed.Supports $filter(lt, le, gt, ge, eq, ne) and $orderby.
     */
    @SerializedName(value = "completedDateTime", alternate = {"CompletedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime completedDateTime;

    /**
     * The Failed Users Count.
     * The number of users in the run execution for which the associated task failed.Supports $filter(lt, le, gt, ge, eq, ne) and $orderby.
     */
    @SerializedName(value = "failedUsersCount", alternate = {"FailedUsersCount"})
    @Expose
	@Nullable
    public Integer failedUsersCount;

    /**
     * The Last Updated Date Time.
     * The date and time that the task report was last updated.
     */
    @SerializedName(value = "lastUpdatedDateTime", alternate = {"LastUpdatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastUpdatedDateTime;

    /**
     * The Processing Status.
     * The processing status of the associated task based on the taskProcessingResults. The possible values are based on the number of queued, inProgress, completed, completedWithErrors, canceled, failed, and unknownFutureValue.Supports $filter(eq, ne) and $orderby.
     */
    @SerializedName(value = "processingStatus", alternate = {"ProcessingStatus"})
    @Expose
	@Nullable
    public LifecycleWorkflowProcessingStatus processingStatus;

    /**
     * The Run Id.
     * The unique identifier of the associated run.
     */
    @SerializedName(value = "runId", alternate = {"RunId"})
    @Expose
	@Nullable
    public String runId;

    /**
     * The Started Date Time.
     * The date time that the associated run started. Value is null if the run has not started.
     */
    @SerializedName(value = "startedDateTime", alternate = {"StartedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime startedDateTime;

    /**
     * The Successful Users Count.
     * The number of users in the run execution for which the associated task succeeded.Supports $filter(lt, le, gt, ge, eq, ne) and $orderby.
     */
    @SerializedName(value = "successfulUsersCount", alternate = {"SuccessfulUsersCount"})
    @Expose
	@Nullable
    public Integer successfulUsersCount;

    /**
     * The Total Users Count.
     * The total number of users in the run execution for which the associated task was scheduled to execute.Supports $filter(lt, le, gt, ge, eq, ne) and $orderby.
     */
    @SerializedName(value = "totalUsersCount", alternate = {"TotalUsersCount"})
    @Expose
	@Nullable
    public Integer totalUsersCount;

    /**
     * The Unprocessed Users Count.
     * The number of users in the run execution for which the associated task is queued, in progress, or canceled.Supports $filter(lt, le, gt, ge, eq, ne) and $orderby.
     */
    @SerializedName(value = "unprocessedUsersCount", alternate = {"UnprocessedUsersCount"})
    @Expose
	@Nullable
    public Integer unprocessedUsersCount;

    /**
     * The Task.
     * The related lifecycle workflow task.Supports $filter(eq, ne) and $expand.
     */
    @SerializedName(value = "task", alternate = {"Task"})
    @Expose
	@Nullable
    public Task task;

    /**
     * The Task Definition.
     * The taskDefinition associated with the related lifecycle workflow task.Supports $filter(eq, ne) and $expand.
     */
    @SerializedName(value = "taskDefinition", alternate = {"TaskDefinition"})
    @Expose
	@Nullable
    public TaskDefinition taskDefinition;

    /**
     * The Task Processing Results.
     * The related lifecycle workflow taskProcessingResults.
     */
    @SerializedName(value = "taskProcessingResults", alternate = {"TaskProcessingResults"})
    @Expose
	@Nullable
    public com.microsoft.graph.identitygovernance.requests.TaskProcessingResultCollectionPage taskProcessingResults;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("taskProcessingResults")) {
            taskProcessingResults = serializer.deserializeObject(json.get("taskProcessingResults"), com.microsoft.graph.identitygovernance.requests.TaskProcessingResultCollectionPage.class);
        }
    }
}
