// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookChart;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Request.
 */
public class WorkbookChartRequest extends BaseRequest<WorkbookChart> {
	
    /**
     * The request for the WorkbookChart
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookChart.class);
    }

    /**
     * Gets the WorkbookChart from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChart> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookChart from the service
     *
     * @return the WorkbookChart from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChart get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChart> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookChart delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookChart with a source
     *
     * @param sourceWorkbookChart the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChart> patchAsync(@Nonnull final WorkbookChart sourceWorkbookChart) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookChart);
    }

    /**
     * Patches this WorkbookChart with a source
     *
     * @param sourceWorkbookChart the source object with updates
     * @return the updated WorkbookChart
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChart patch(@Nonnull final WorkbookChart sourceWorkbookChart) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChart);
    }

    /**
     * Creates a WorkbookChart with a new object
     *
     * @param newWorkbookChart the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChart> postAsync(@Nonnull final WorkbookChart newWorkbookChart) {
        return sendAsync(HttpMethod.POST, newWorkbookChart);
    }

    /**
     * Creates a WorkbookChart with a new object
     *
     * @param newWorkbookChart the new object to create
     * @return the created WorkbookChart
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChart post(@Nonnull final WorkbookChart newWorkbookChart) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChart);
    }

    /**
     * Creates a WorkbookChart with a new object
     *
     * @param newWorkbookChart the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChart> putAsync(@Nonnull final WorkbookChart newWorkbookChart) {
        return sendAsync(HttpMethod.PUT, newWorkbookChart);
    }

    /**
     * Creates a WorkbookChart with a new object
     *
     * @param newWorkbookChart the object to create/update
     * @return the created WorkbookChart
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChart put(@Nonnull final WorkbookChart newWorkbookChart) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookChart);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookChartRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookChartRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

